"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _rawNodeString = _interopRequireDefault(require("../../utils/rawNodeString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-closing-brace-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected newline after \"}\"";
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return "Expected newline after \"}\" of a single-line block";
  },
  rejectedAfterSingleLine: function rejectedAfterSingleLine() {
    return "Unexpected whitespace after \"}\" of a single-line block";
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return "Expected newline after \"}\" of a multi-line block";
  },
  rejectedAfterMultiLine: function rejectedAfterMultiLine() {
    return "Unexpected whitespace after \"}\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-closing-brace-newline-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-single-line", "never-single-line", "always-multi-line", "never-multi-line"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignoreAtRules: [_validateTypes.isString]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      if (!(0, _hasBlock["default"])(statement)) {
        return;
      }
      if (statement.type === "atrule" && (0, _optionsMatches["default"])(secondaryOptions, "ignoreAtRules", statement.name)) {
        return;
      }
      var nextNode = statement.next();
      if (!nextNode) {
        return;
      }

      // Allow an end-of-line comment x spaces after the brace
      var nextNodeIsSingleLineComment = nextNode.type === "comment" && !/[^ ]/.test(nextNode.raws.before || "") && !nextNode.toString().includes("\n");
      var nodeToCheck = nextNodeIsSingleLineComment ? nextNode.next() : nextNode;
      if (!nodeToCheck) {
        return;
      }
      var reportIndex = statement.toString().length;
      var source = (0, _rawNodeString["default"])(nodeToCheck);

      // Skip a semicolon at the beginning, if any
      if (source && source.startsWith(";")) {
        source = source.slice(1);
        reportIndex++;
      }

      // Only check one after, because there might be other
      // spaces handled by the indentation rule
      checker.afterOneOnly({
        source: source,
        index: -1,
        lineCheckStr: (0, _blockString["default"])(statement),
        err: function err(msg) {
          if (context.fix) {
            var nodeToCheckRaws = nodeToCheck.raws;
            if (_typeof(nodeToCheckRaws.before) !== "string") {
              return;
            }
            if (primary.startsWith("always")) {
              var index = nodeToCheckRaws.before.search(/\r?\n/);
              nodeToCheckRaws.before = index >= 0 ? nodeToCheckRaws.before.slice(index) : context.newline + nodeToCheckRaws.before;
              return;
            }
            if (primary.startsWith("never")) {
              nodeToCheckRaws.before = "";
              return;
            }
          }
          (0, _report["default"])({
            message: msg,
            node: statement,
            index: reportIndex,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;