"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _isSingleLineString = _interopRequireDefault(require("../../utils/isSingleLineString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-closing-brace-newline-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: "Expected newline before \"}\"",
  expectedBeforeMultiLine: "Expected newline before \"}\" of a multi-line block",
  rejectedBeforeMultiLine: "Unexpected whitespace before \"}\" of a multi-line block"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-closing-brace-newline-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
    	 * @param {import('postcss').Rule | import('postcss').AtRule} statement
    	 */
    function check(statement) {
      // Return early if blockless or has empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }

      // Ignore extra semicolon
      var after = (statement.raws.after || "").replace(/;+/, "");
      if (after === undefined) {
        return;
      }
      var blockIsMultiLine = !(0, _isSingleLineString["default"])((0, _blockString["default"])(statement));
      var statementString = statement.toString();
      var index = statementString.length - 2;
      if (statementString[index - 1] === "\r") {
        index -= 1;
      }

      // We're really just checking whether a
      // newline *starts* the block's final space -- between
      // the last declaration and the closing brace. We can
      // ignore any other whitespace between them, because that
      // will be checked by the indentation rule.
      if (!after.startsWith("\n") && !after.startsWith("\r\n")) {
        if (primary === "always") {
          complain(messages.expectedBefore);
        } else if (blockIsMultiLine && primary === "always-multi-line") {
          complain(messages.expectedBeforeMultiLine);
        }
      }
      if (after !== "" && blockIsMultiLine && primary === "never-multi-line") {
        complain(messages.rejectedBeforeMultiLine);
      }

      /**
      	 * @param {string} message
      	 */
      function complain(message) {
        if (context.fix) {
          var statementRaws = statement.raws;
          if (_typeof(statementRaws.after) !== "string") {
            return;
          }
          if (primary.startsWith("always")) {
            var firstWhitespaceIndex = statementRaws.after.search(/\s/);
            var newlineBefore = firstWhitespaceIndex >= 0 ? statementRaws.after.slice(0, firstWhitespaceIndex) : statementRaws.after;
            var newlineAfter = firstWhitespaceIndex >= 0 ? statementRaws.after.slice(firstWhitespaceIndex) : "";
            var newlineIndex = newlineAfter.search(/\r?\n/);
            statementRaws.after = newlineIndex >= 0 ? newlineBefore + newlineAfter.slice(newlineIndex) : newlineBefore + context.newline + newlineAfter;
            return;
          }
          if (primary === "never-multi-line") {
            statementRaws.after = statementRaws.after.replace(/\s/g, "");
            return;
          }
        }
        (0, _report["default"])({
          message: message,
          result: result,
          ruleName: ruleName,
          node: statement,
          index: index
        });
      }
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;