"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-closing-brace-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \"}\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \"}\"";
  },
  expectedBeforeSingleLine: function expectedBeforeSingleLine() {
    return "Expected single space before \"}\" of a single-line block";
  },
  rejectedBeforeSingleLine: function rejectedBeforeSingleLine() {
    return "Unexpected whitespace before \"}\" of a single-line block";
  },
  expectedBeforeMultiLine: function expectedBeforeMultiLine() {
    return "Expected single space before \"}\" of a multi-line block";
  },
  rejectedBeforeMultiLine: function rejectedBeforeMultiLine() {
    return "Unexpected whitespace before \"}\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-closing-brace-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statement: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      // Return early if blockless or has empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }
      var source = (0, _blockString["default"])(statement);
      var statementString = statement.toString();
      var index = statementString.length - 2;
      if (statementString[index - 1] === "\r") {
        index -= 1;
      }
      checker.before({
        source: source,
        index: source.length - 1,
        err: function err(msg) {
          if (context.fix) {
            var statementRaws = statement.raws;
            if (_typeof(statementRaws.after) !== "string") {
              return;
            }
            if (primary.startsWith("always")) {
              statementRaws.after = statementRaws.after.replace(/\s*$/, " ");
              return;
            }
            if (primary.startsWith("never")) {
              statementRaws.after = statementRaws.after.replace(/\s*$/, "");
              return;
            }
          }
          (0, _report["default"])({
            message: msg,
            node: statement,
            index: index,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;