"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _beforeBlockString = _interopRequireDefault(require("../../utils/beforeBlockString.js"));
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _rawNodeString = _interopRequireDefault(require("../../utils/rawNodeString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-opening-brace-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected newline after \"{\"";
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return "Expected newline after \"{\" of a multi-line block";
  },
  rejectedAfterMultiLine: function rejectedAfterMultiLine() {
    return "Unexpected whitespace after \"{\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-opening-brace-newline-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "rules", "always-multi-line", "never-multi-line"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignore: ["rules"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statement: rules and at-rules
    if (!(0, _optionsMatches["default"])(secondaryOptions, "ignore", "rules")) {
      root.walkRules(check);
    }
    root.walkAtRules(check);

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      // Return early if blockless or has an empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }
      var backupCommentNextBefores = new Map();

      /**
       * next node with checking newlines after comment
       *
       * @param {import('postcss').ChildNode | undefined} startNode
       * @returns {import('postcss').ChildNode | undefined}
       */
      function nextNode(startNode) {
        if (!startNode || !startNode.next) {
          return;
        }
        if (startNode.type === "comment") {
          var reNewLine = /\r?\n/;
          var newLineMatch = reNewLine.test(startNode.raws.before || "");
          var next = startNode.next();
          if (next && newLineMatch && !reNewLine.test(next.raws.before || "")) {
            backupCommentNextBefores.set(next, next.raws.before);
            next.raws.before = startNode.raws.before;
          }
          return nextNode(next);
        }
        return startNode;
      }

      // Allow an end-of-line comment
      var nodeToCheck = nextNode(statement.first);
      if (!nodeToCheck) {
        return;
      }
      checker.afterOneOnly({
        source: (0, _rawNodeString["default"])(nodeToCheck),
        index: -1,
        lineCheckStr: (0, _blockString["default"])(statement),
        err: function err(m) {
          if (context.fix) {
            var nodeToCheckRaws = nodeToCheck.raws;
            if (_typeof(nodeToCheckRaws.before) !== "string") {
              return;
            }
            if (primary.startsWith("always")) {
              var index = nodeToCheckRaws.before.search(/\r?\n/);
              nodeToCheckRaws.before = index >= 0 ? nodeToCheckRaws.before.slice(index) : context.newline + nodeToCheckRaws.before;
              backupCommentNextBefores["delete"](nodeToCheck);
              return;
            }
            if (primary === "never-multi-line") {
              // Restore the `before` of the node next to the comment node.
              var _iterator = _createForOfIteratorHelper(backupCommentNextBefores.entries()),
                _step;
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  var _step$value = _slicedToArray(_step.value, 2),
                    node = _step$value[0],
                    before = _step$value[1];
                  node.raws.before = before;
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
              backupCommentNextBefores.clear();

              // Fix
              var reNewLine = /\r?\n/;
              var fixTarget = statement.first;
              while (fixTarget) {
                var fixTargetRaws = fixTarget.raws;
                if (_typeof(fixTargetRaws.before) !== "string") {
                  continue;
                }
                if (reNewLine.test(fixTargetRaws.before || "")) {
                  fixTargetRaws.before = fixTargetRaws.before.replace(/\r?\n/g, "");
                }
                if (fixTarget.type !== "comment") {
                  break;
                }
                fixTarget = fixTarget.next();
              }
              nodeToCheckRaws.before = "";
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: statement,
            index: (0, _beforeBlockString["default"])(statement, {
              noRawBefore: true
            }).length + 1,
            result: result,
            ruleName: ruleName
          });
        }
      });

      // Restore the `before` of the node next to the comment node.
      var _iterator2 = _createForOfIteratorHelper(backupCommentNextBefores.entries()),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _step2$value = _slicedToArray(_step2.value, 2),
            node = _step2$value[0],
            before = _step2$value[1];
          node.raws.before = before;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;