"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _beforeBlockString = _interopRequireDefault(require("../../utils/beforeBlockString.js"));
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "block-opening-brace-newline-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected newline before \"{\"";
  },
  expectedBeforeSingleLine: function expectedBeforeSingleLine() {
    return "Expected newline before \"{\" of a single-line block";
  },
  rejectedBeforeSingleLine: function rejectedBeforeSingleLine() {
    return "Unexpected whitespace before \"{\" of a single-line block";
  },
  expectedBeforeMultiLine: function expectedBeforeMultiLine() {
    return "Expected newline before \"{\" of a multi-line block";
  },
  rejectedBeforeMultiLine: function rejectedBeforeMultiLine() {
    return "Unexpected whitespace before \"{\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-opening-brace-newline-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-single-line", "never-single-line", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statement: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      // Return early if blockless or has an empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }
      var source = (0, _beforeBlockString["default"])(statement);
      var beforeBraceNoRaw = (0, _beforeBlockString["default"])(statement, {
        noRawBefore: true
      });
      var index = beforeBraceNoRaw.length - 1;
      if (beforeBraceNoRaw[index - 1] === "\r") {
        index -= 1;
      }
      checker.beforeAllowingIndentation({
        lineCheckStr: (0, _blockString["default"])(statement),
        source: source,
        index: source.length,
        err: function err(m) {
          if (context.fix) {
            var statementRaws = statement.raws;
            if (_typeof(statementRaws.between) !== "string") {
              return;
            }
            if (primary.startsWith("always")) {
              var spaceIndex = statementRaws.between.search(/\s+$/);
              if (spaceIndex >= 0) {
                statement.raws.between = statementRaws.between.slice(0, spaceIndex) + context.newline + statementRaws.between.slice(spaceIndex);
              } else {
                statementRaws.between += context.newline;
              }
              return;
            }
            if (primary.startsWith("never")) {
              statementRaws.between = statementRaws.between.replace(/\s*$/, "");
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: statement,
            index: index,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;