"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _beforeBlockString = _interopRequireDefault(require("../../utils/beforeBlockString.js"));
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "block-opening-brace-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after \"{\"";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after \"{\"";
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return "Expected single space after \"{\" of a single-line block";
  },
  rejectedAfterSingleLine: function rejectedAfterSingleLine() {
    return "Unexpected whitespace after \"{\" of a single-line block";
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return "Expected single space after \"{\" of a multi-line block";
  },
  rejectedAfterMultiLine: function rejectedAfterMultiLine() {
    return "Unexpected whitespace after \"{\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-opening-brace-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line", "always-multi-line", "never-multi-line"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignore: ["at-rules"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    if (!(0, _optionsMatches["default"])(secondaryOptions, "ignore", "at-rules")) {
      root.walkAtRules(check);
    }

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      // Return early if blockless or has an empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }
      checker.after({
        source: (0, _blockString["default"])(statement),
        index: 0,
        err: function err(m) {
          if (context.fix) {
            var statementFirst = statement.first;
            if (statementFirst === null) {
              return;
            }
            if (primary.startsWith("always")) {
              statementFirst.raws.before = " ";
              return;
            }
            if (primary.startsWith("never")) {
              statementFirst.raws.before = "";
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: statement,
            index: (0, _beforeBlockString["default"])(statement, {
              noRawBefore: true
            }).length + 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;