"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _beforeBlockString = _interopRequireDefault(require("../../utils/beforeBlockString.js"));
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _hasEmptyBlock = _interopRequireDefault(require("../../utils/hasEmptyBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "block-opening-brace-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \"{\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \"{\"";
  },
  expectedBeforeSingleLine: function expectedBeforeSingleLine() {
    return "Expected single space before \"{\" of a single-line block";
  },
  rejectedBeforeSingleLine: function rejectedBeforeSingleLine() {
    return "Unexpected whitespace before \"{\" of a single-line block";
  },
  expectedBeforeMultiLine: function expectedBeforeMultiLine() {
    return "Expected single space before \"{\" of a multi-line block";
  },
  rejectedBeforeMultiLine: function rejectedBeforeMultiLine() {
    return "Unexpected whitespace before \"{\" of a multi-line block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/block-opening-brace-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line", "always-multi-line", "never-multi-line"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignoreAtRules: [_validateTypes.isString, _validateTypes.isRegExp],
        ignoreSelectors: [_validateTypes.isString, _validateTypes.isRegExp]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }

    // Check both kinds of statements: rules and at-rules
    root.walkRules(check);
    root.walkAtRules(check);

    /**
     * @param {import('postcss').Rule | import('postcss').AtRule} statement
     */
    function check(statement) {
      // Return early if blockless or has an empty block
      if (!(0, _hasBlock["default"])(statement) || (0, _hasEmptyBlock["default"])(statement)) {
        return;
      }

      // Return early if at-rule is to be ignored
      if (statement.type === "atrule" && (0, _optionsMatches["default"])(secondaryOptions, "ignoreAtRules", statement.name)) {
        return;
      }

      // Return early if selector is to be ignored
      if (statement.type === "rule" && (0, _optionsMatches["default"])(secondaryOptions, "ignoreSelectors", statement.selector)) {
        return;
      }
      var source = (0, _beforeBlockString["default"])(statement);
      var beforeBraceNoRaw = (0, _beforeBlockString["default"])(statement, {
        noRawBefore: true
      });
      var index = beforeBraceNoRaw.length - 1;
      if (beforeBraceNoRaw[index - 1] === "\r") {
        index -= 1;
      }
      checker.before({
        source: source,
        index: source.length,
        lineCheckStr: (0, _blockString["default"])(statement),
        err: function err(m) {
          if (context.fix) {
            if (primary.startsWith("always")) {
              statement.raws.between = " ";
              return;
            }
            if (primary.startsWith("never")) {
              statement.raws.between = "";
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: statement,
            index: index,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;