"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "color-hex-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/color-hex-case/README.md",
  fixable: true
};
exports.meta = meta;
var HEX = /^#[0-9A-Za-z]+/;
var IGNORED_FUNCTIONS = new Set(["url"]);

/** @type {import('stylelint').Rule} */
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      var parsedValue = (0, _postcssValueParser["default"])((0, _getDeclarationValue["default"])(decl));
      var needsFix = false;
      parsedValue.walk(function (node) {
        var value = node.value;
        if (isIgnoredFunction(node)) {
          return false;
        }
        if (!isHexColor(node)) {
          return;
        }
        var expected = primary === "lower" ? value.toLowerCase() : value.toUpperCase();
        if (value === expected) {
          return;
        }
        if (context.fix) {
          node.value = expected;
          needsFix = true;
          return;
        }
        (0, _report["default"])({
          message: messages.expected(value, expected),
          node: decl,
          index: (0, _declarationValueIndex["default"])(decl) + node.sourceIndex,
          result: result,
          ruleName: ruleName
        });
      });
      if (needsFix) {
        (0, _setDeclarationValue["default"])(decl, parsedValue.toString());
      }
    });
  };
};

/**
 * @param {import('postcss-value-parser').Node} node
 */
function isIgnoredFunction(_ref) {
  var type = _ref.type,
    value = _ref.value;
  return type === "function" && IGNORED_FUNCTIONS.has(value.toLowerCase());
}

/**
 * @param {import('postcss-value-parser').Node} node
 */
function isHexColor(_ref2) {
  var type = _ref2.type,
    value = _ref2.value;
  return type === "word" && HEX.test(value);
}
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;