"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _declarationBangSpaceChecker = _interopRequireDefault(require("../declarationBangSpaceChecker.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-bang-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after \"!\"";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after \"!\"";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-bang-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    (0, _declarationBangSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName,
      fix: context.fix ? function (decl, index) {
        var bangIndex = index - (0, _declarationValueIndex["default"])(decl);
        var declValue = (0, _getDeclarationValue["default"])(decl);
        var target;
        /** @type {(value: string) => void} */
        var setFixed;
        if (bangIndex < declValue.length) {
          target = declValue;
          setFixed = function setFixed(value) {
            (0, _setDeclarationValue["default"])(decl, value);
          };
        } else if (decl.important) {
          target = decl.raws.important || " !important";
          bangIndex -= declValue.length;
          setFixed = function setFixed(value) {
            decl.raws.important = value;
          };
        } else {
          return false; // not standard
        }

        var targetBefore = target.slice(0, bangIndex + 1);
        var targetAfter = target.slice(bangIndex + 1);
        if (primary === "always") {
          setFixed(targetBefore + targetAfter.replace(/^\s*/, " "));
          return true;
        }
        if (primary === "never") {
          setFixed(targetBefore + targetAfter.replace(/^\s*/, ""));
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;