"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _declarationBangSpaceChecker = _interopRequireDefault(require("../declarationBangSpaceChecker.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-bang-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \"!\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \"!\"";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-bang-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    (0, _declarationBangSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.before,
      checkedRuleName: ruleName,
      fix: context.fix ? function (decl, index) {
        var bangIndex = index - (0, _declarationValueIndex["default"])(decl);
        var value = (0, _getDeclarationValue["default"])(decl);
        var target;
        /** @type {(val: string) => void} */
        var setFixed;
        if (bangIndex < value.length) {
          target = value;
          setFixed = function setFixed(val) {
            (0, _setDeclarationValue["default"])(decl, val);
          };
        } else if (decl.important) {
          target = decl.raws.important || " !important";
          bangIndex -= value.length;
          setFixed = function setFixed(val) {
            decl.raws.important = val;
          };
        } else {
          return false; // not standard
        }

        var targetBefore = target.slice(0, bangIndex);
        var targetAfter = target.slice(bangIndex);
        if (primary === "always") {
          setFixed("".concat(targetBefore.replace(/\s*$/, ""), " ").concat(targetAfter));
          return true;
        }
        if (primary === "never") {
          setFixed(targetBefore.replace(/\s*$/, "") + targetAfter);
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;