"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
var _typeGuards = require("../../utils/typeGuards.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-block-semicolon-newline-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected newline before \";\"";
  },
  expectedBeforeMultiLine: function expectedBeforeMultiLine() {
    return "Expected newline before \";\" in a multi-line declaration block";
  },
  rejectedBeforeMultiLine: function rejectedBeforeMultiLine() {
    return "Unexpected whitespace before \";\" in a multi-line declaration block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-block-semicolon-newline-before/README.md"
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      var parentRule = decl.parent;
      if (!parentRule) {
        throw new Error("A parent node must be present");
      }
      if (!(0, _typeGuards.isAtRule)(parentRule) && !(0, _typeGuards.isRule)(parentRule)) {
        return;
      }
      if (!parentRule.raws.semicolon && parentRule.last === decl) {
        return;
      }
      var declString = decl.toString();
      checker.beforeAllowingIndentation({
        source: declString,
        index: declString.length,
        lineCheckStr: (0, _blockString["default"])(parentRule),
        err: function err(m) {
          (0, _report["default"])({
            message: m,
            node: decl,
            index: decl.toString().length - 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;