"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _rawNodeString = _interopRequireDefault(require("../../utils/rawNodeString.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
var _typeGuards = require("../../utils/typeGuards.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-block-semicolon-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after \";\"";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after \";\"";
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return "Expected single space after \";\" in a single-line declaration block";
  },
  rejectedAfterSingleLine: function rejectedAfterSingleLine() {
    return "Unexpected whitespace after \";\" in a single-line declaration block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-block-semicolon-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      // Ignore last declaration if there's no trailing semicolon
      var parentRule = decl.parent;
      if (!parentRule) {
        throw new Error("A parent node must be present");
      }
      if (!(0, _typeGuards.isAtRule)(parentRule) && !(0, _typeGuards.isRule)(parentRule)) {
        return;
      }
      if (!parentRule.raws.semicolon && parentRule.last === decl) {
        return;
      }
      var nextDecl = decl.next();
      if (!nextDecl) {
        return;
      }
      checker.after({
        source: (0, _rawNodeString["default"])(nextDecl),
        index: -1,
        lineCheckStr: (0, _blockString["default"])(parentRule),
        err: function err(m) {
          if (context.fix) {
            if (primary.startsWith("always")) {
              nextDecl.raws.before = " ";
              return;
            }
            if (primary.startsWith("never")) {
              nextDecl.raws.before = "";
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: decl,
            index: decl.toString().length + 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;