"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _blockString = _interopRequireDefault(require("../../utils/blockString.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
var _typeGuards = require("../../utils/typeGuards.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-block-semicolon-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \";\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \";\"";
  },
  expectedBeforeSingleLine: function expectedBeforeSingleLine() {
    return "Expected single space before \";\" in a single-line declaration block";
  },
  rejectedBeforeSingleLine: function rejectedBeforeSingleLine() {
    return "Unexpected whitespace before \";\" in a single-line declaration block";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-block-semicolon-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      // Ignore last declaration if there's no trailing semicolon
      var parentRule = decl.parent;
      if (!parentRule) {
        throw new Error("A parent node must be present");
      }
      if (!(0, _typeGuards.isAtRule)(parentRule) && !(0, _typeGuards.isRule)(parentRule)) {
        return;
      }
      if (!parentRule.raws.semicolon && parentRule.last === decl) {
        return;
      }
      var declString = decl.toString();
      checker.before({
        source: declString,
        index: declString.length,
        lineCheckStr: (0, _blockString["default"])(parentRule),
        err: function err(m) {
          if (context.fix) {
            var value = (0, _getDeclarationValue["default"])(decl);
            if (primary.startsWith("always")) {
              if (decl.important) {
                decl.raws.important = " !important ";
              } else {
                (0, _setDeclarationValue["default"])(decl, value.replace(/\s*$/, " "));
              }
              return;
            }
            if (primary.startsWith("never")) {
              if (decl.raws.important) {
                decl.raws.important = decl.raws.important.replace(/\s*$/, "");
              } else {
                (0, _setDeclarationValue["default"])(decl, value.replace(/\s*$/, ""));
              }
              return;
            }
          }
          (0, _report["default"])({
            message: m,
            node: decl,
            index: decl.toString().length - 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;