"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _typeGuards = require("../../utils/typeGuards.js");
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-block-trailing-semicolon";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: "Expected a trailing semicolon",
  rejected: "Unexpected trailing semicolon"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-block-trailing-semicolon/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignore: ["single-declaration"]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(function (atRule) {
      if (!atRule.parent) {
        throw new Error("A parent node must be present");
      }
      if (atRule.parent === root) {
        return;
      }
      if (atRule !== atRule.parent.last) {
        return;
      }
      if ((0, _hasBlock["default"])(atRule)) {
        return;
      }
      checkLastNode(atRule);
    });
    root.walkDecls(function (decl) {
      if (!decl.parent) {
        throw new Error("A parent node must be present");
      }
      if (decl.parent.type === "object") {
        return;
      }
      if (decl !== decl.parent.last) {
        return;
      }
      checkLastNode(decl);
    });

    /**
    	 * @param {import('postcss').Node} node
    	 */
    function checkLastNode(node) {
      if (!node.parent) {
        throw new Error("A parent node must be present");
      }
      var hasSemicolon = node.parent.raws.semicolon;
      var ignoreSingleDeclaration = (0, _optionsMatches["default"])(secondaryOptions, "ignore", "single-declaration");
      if (ignoreSingleDeclaration && node.parent.first === node) {
        return;
      }
      var message;
      if (primary === "always") {
        if (hasSemicolon) {
          return;
        }

        // auto-fix
        if (context.fix) {
          node.parent.raws.semicolon = true;
          if ((0, _typeGuards.isAtRule)(node)) {
            node.raws.between = "";
            node.parent.raws.after = " ";
          }
          return;
        }
        message = messages.expected;
      } else if (primary === "never") {
        if (!hasSemicolon) {
          return;
        }

        // auto-fix
        if (context.fix) {
          node.parent.raws.semicolon = false;
          return;
        }
        message = messages.rejected;
      } else {
        throw new Error("Unexpected primary option: \"".concat(primary, "\""));
      }
      (0, _report["default"])({
        message: message,
        node: node,
        index: node.toString().trim().length - 1,
        result: result,
        ruleName: ruleName
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;