"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _isStandardSyntaxDeclaration = _interopRequireDefault(require("../../utils/isStandardSyntaxDeclaration.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-colon-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected newline after \":\"";
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return "Expected newline after \":\" with a multi-line declaration";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-colon-newline-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      if (!(0, _isStandardSyntaxDeclaration["default"])(decl)) {
        return;
      }

      // Get the raw prop, and only the prop
      var endOfPropIndex = (0, _declarationValueIndex["default"])(decl) + (decl.raws.between || "").length - 1;

      // The extra characters tacked onto the end ensure that there is a character to check
      // after the colon. Otherwise, with `background:pink` the character after the
      var propPlusColon = "".concat(decl.toString().slice(0, endOfPropIndex), "xxx");
      var _loop = function _loop() {
        if (propPlusColon[i] !== ":") {
          return 1; // continue
        }
        var indexToCheck = /^[^\S\r\n]*\/\*/.test(propPlusColon.slice(i + 1)) ? propPlusColon.indexOf("*/", i) + 1 : i;
        checker.afterOneOnly({
          source: propPlusColon,
          index: indexToCheck,
          lineCheckStr: decl.value,
          err: function err(m) {
            if (context.fix) {
              var between = decl.raws.between;
              if (between === null) {
                throw new Error("`between` must be present");
              }
              var betweenStart = (0, _declarationValueIndex["default"])(decl) - between.length;
              var sliceIndex = indexToCheck - betweenStart + 1;
              var betweenBefore = between.slice(0, sliceIndex);
              var betweenAfter = between.slice(sliceIndex);
              decl.raws.between = /^\s*\n/.test(betweenAfter) ? betweenBefore + betweenAfter.replace(/^[^\S\r\n]*/, "") : betweenBefore + context.newline + betweenAfter;
              return;
            }
            (0, _report["default"])({
              message: m,
              node: decl,
              index: indexToCheck,
              result: result,
              ruleName: ruleName
            });
          }
        });
      };
      for (var i = 0, l = propPlusColon.length; i < l; i++) {
        if (_loop()) continue;
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;