"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _declarationColonSpaceChecker = _interopRequireDefault(require("../declarationColonSpaceChecker.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "declaration-colon-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after \":\"";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after \":\"";
  },
  expectedAfterSingleLine: function expectedAfterSingleLine() {
    return "Expected single space after \":\" with a single-line declaration";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/declaration-colon-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line"]
    });
    if (!validOptions) {
      return;
    }
    (0, _declarationColonSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName,
      fix: context.fix ? function (decl, index) {
        var colonIndex = index - (0, _declarationValueIndex["default"])(decl);
        var between = decl.raws.between;
        if (between === null) {
          throw new Error("`between` must be present");
        }
        if (primary.startsWith("always")) {
          decl.raws.between = between.slice(0, colonIndex) + between.slice(colonIndex).replace(/^:\s*/, ": ");
          return true;
        }
        if (primary === "never") {
          decl.raws.between = between.slice(0, colonIndex) + between.slice(colonIndex).replace(/^:\s*/, ":");
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;