"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = declarationBangSpaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _declarationValueIndex = _interopRequireDefault(require("../utils/declarationValueIndex.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/** @typedef {import('postcss').Declaration} Declaration */

/** @typedef {(args: { source: string, index: number, err: (message: string) => void }) => void} LocationChecker */
/**
 * @param {{
 *   root: import('postcss').Root,
 *   locationChecker: LocationChecker,
 *   result: import('stylelint').PostcssResult,
 *   checkedRuleName: string,
 *   fix: ((decl: Declaration, index: number) => boolean) | null,
 * }} opts
 * @returns {void}
 */
function declarationBangSpaceChecker(opts) {
  opts.root.walkDecls(function (decl) {
    var indexOffset = (0, _declarationValueIndex["default"])(decl);
    var declString = decl.toString();
    var valueString = decl.toString().slice(indexOffset);
    if (!valueString.includes("!")) {
      return;
    }
    (0, _styleSearch["default"])({
      source: valueString,
      target: "!"
    }, function (match) {
      check(declString, match.startIndex + indexOffset, decl);
    });
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {Declaration} decl
   */
  function check(source, index, decl) {
    opts.locationChecker({
      source: source,
      index: index,
      err: function err(message) {
        if (opts.fix && opts.fix(decl, index)) {
          return;
        }
        (0, _report["default"])({
          message: message,
          node: decl,
          index: index,
          result: opts.result,
          ruleName: opts.checkedRuleName
        });
      }
    });
  }
}