"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = declarationColonSpaceChecker;
var _declarationValueIndex = _interopRequireDefault(require("../utils/declarationValueIndex.js"));
var _isStandardSyntaxDeclaration = _interopRequireDefault(require("../utils/isStandardSyntaxDeclaration.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/** @typedef {(args: { source: string, index: number, lineCheckStr: string, err: (message: string) => void }) => void} LocationChecker */
/**
 * @param {{
 *   root: import('postcss').Root,
 *   locationChecker: LocationChecker,
 *   fix: ((decl: import('postcss').Declaration, index: number) => boolean) | null,
 *   result: import('stylelint').PostcssResult,
 *   checkedRuleName: string,
 * }} opts
 */
function declarationColonSpaceChecker(opts) {
  opts.root.walkDecls(function (decl) {
    if (!(0, _isStandardSyntaxDeclaration["default"])(decl)) {
      return;
    }

    // Get the raw prop, and only the prop
    var endOfPropIndex = (0, _declarationValueIndex["default"])(decl) + (decl.raws.between || "").length - 1;

    // The extra characters tacked onto the end ensure that there is a character to check
    // after the colon. Otherwise, with `background:pink` the character after the
    var propPlusColon = "".concat(decl.toString().slice(0, endOfPropIndex), "xxx");
    var _loop = function _loop(i) {
        if (propPlusColon[i] !== ":") {
          return 0; // continue
        }
        opts.locationChecker({
          source: propPlusColon,
          index: i,
          lineCheckStr: decl.value,
          err: function err(message) {
            if (opts.fix && opts.fix(decl, i)) {
              return;
            }
            (0, _report["default"])({
              message: message,
              node: decl,
              index: decl.prop.toString().length + 1,
              result: opts.result,
              ruleName: opts.checkedRuleName
            });
          }
        });
        return 1; // break
      },
      _ret;
    for (var i = 0, l = propPlusColon.length; i < l; i++) {
      _ret = _loop(i);
      if (_ret === 0) continue;
      if (_ret === 1) break;
    }
  });
}