"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = findMediaOperator;
var _styleSearch = _interopRequireDefault(require("style-search"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var rangeOperators = [">=", "<=", ">", "<", "="];

/** @typedef {import('style-search').StyleSearchMatch} StyleSearchMatch */

/**
 * @template {import('postcss').AtRule} T
 * @param {T} atRule
 * @param {(match: StyleSearchMatch, params: string, atRule: T) => void} cb
 */
function findMediaOperator(atRule, cb) {
  if (atRule.name.toLowerCase() !== "media") {
    return;
  }
  var params = atRule.raws.params ? atRule.raws.params.raw : atRule.params;
  (0, _styleSearch["default"])({
    source: params,
    target: rangeOperators
  }, function (match) {
    var before = params[match.startIndex - 1];
    if (before === ">" || before === "<") {
      return;
    }
    cb(match, params, atRule);
  });
}