"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _functionCommaSpaceFix = _interopRequireDefault(require("../functionCommaSpaceFix.js"));
var _functionCommaSpaceChecker = _interopRequireDefault(require("../functionCommaSpaceChecker.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "function-comma-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore() {
    return "Expected single space before \",\"";
  },
  rejectedBefore: function rejectedBefore() {
    return "Unexpected whitespace before \",\"";
  },
  expectedBeforeSingleLine: function expectedBeforeSingleLine() {
    return "Expected single space before \",\" in a single-line function";
  },
  rejectedBeforeSingleLine: function rejectedBeforeSingleLine() {
    return "Unexpected whitespace before \",\" in a single-line function";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/function-comma-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line"]
    });
    if (!validOptions) {
      return;
    }
    (0, _functionCommaSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.before,
      checkedRuleName: ruleName,
      fix: context.fix ? function (div, index, nodes) {
        return (0, _functionCommaSpaceFix["default"])({
          div: div,
          index: index,
          nodes: nodes,
          expectation: primary,
          position: "before",
          symb: " "
        });
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;