"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "function-max-empty-lines";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(max) {
    return "Expected no more than ".concat(max, " empty ").concat(max === 1 ? "line" : "lines");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/function-max-empty-lines/README.md",
  fixable: true
};

/**
 * @param {import('postcss').Declaration} decl
 */
exports.meta = meta;
function placeIndexOnValueStart(decl) {
  if (decl.raws.between === null) {
    throw new Error("`between` must be present");
  }
  return decl.prop.length + decl.raws.between.length - 1;
}

/** @type {import('stylelint').Rule} */
var rule = function rule(primary, _secondaryOptions, context) {
  var maxAdjacentNewlines = primary + 1;
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: _validateTypes.isNumber
    });
    if (!validOptions) {
      return;
    }
    var violatedCRLFNewLinesRegex = new RegExp("(?:\r\n){".concat(maxAdjacentNewlines + 1, ",}"));
    var violatedLFNewLinesRegex = new RegExp("\n{".concat(maxAdjacentNewlines + 1, ",}"));
    var allowedLFNewLinesString = context.fix ? "\n".repeat(maxAdjacentNewlines) : "";
    var allowedCRLFNewLinesString = context.fix ? "\r\n".repeat(maxAdjacentNewlines) : "";
    root.walkDecls(function (decl) {
      if (!decl.value.includes("(")) {
        return;
      }
      var stringValue = (0, _getDeclarationValue["default"])(decl);
      /** @type {Array<[string, string]>} */
      var splittedValue = [];
      var sourceIndexStart = 0;
      (0, _postcssValueParser["default"])(stringValue).walk(function (node) {
        if (node.type !== "function" /* ignore non functions */ || node.value.length === 0 /* ignore sass lists */) {
          return;
        }
        var stringifiedNode = _postcssValueParser["default"].stringify(node);
        if (!violatedLFNewLinesRegex.test(stringifiedNode) && !violatedCRLFNewLinesRegex.test(stringifiedNode)) {
          return;
        }
        if (context.fix) {
          var newNodeString = stringifiedNode.replace(new RegExp(violatedLFNewLinesRegex, "gm"), allowedLFNewLinesString).replace(new RegExp(violatedCRLFNewLinesRegex, "gm"), allowedCRLFNewLinesString);
          splittedValue.push([stringValue.slice(sourceIndexStart, node.sourceIndex), newNodeString]);
          sourceIndexStart = node.sourceIndex + stringifiedNode.length;
        } else {
          (0, _report["default"])({
            message: messages.expected(primary),
            node: decl,
            index: placeIndexOnValueStart(decl) + node.sourceIndex,
            result: result,
            ruleName: ruleName
          });
        }
      });
      if (context.fix && splittedValue.length > 0) {
        var updatedValue = splittedValue.reduce(function (acc, curr) {
          return acc + curr[0] + curr[1];
        }, "") + stringValue.slice(sourceIndexStart);
        (0, _setDeclarationValue["default"])(decl, updatedValue);
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;