"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _isSingleLineString = _interopRequireDefault(require("../../utils/isSingleLineString.js"));
var _isStandardSyntaxFunction = _interopRequireDefault(require("../../utils/isStandardSyntaxFunction.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "function-parentheses-newline-inside";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedOpening: "Expected newline after \"(\"",
  expectedClosing: "Expected newline before \")\"",
  expectedOpeningMultiLine: "Expected newline after \"(\" in a multi-line function",
  rejectedOpeningMultiLine: "Unexpected whitespace after \"(\" in a multi-line function",
  expectedClosingMultiLine: "Expected newline before \")\" in a multi-line function",
  rejectedClosingMultiLine: "Unexpected whitespace before \")\" in a multi-line function"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/function-parentheses-newline-inside/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      if (!decl.value.includes("(")) {
        return;
      }
      var hasFixed = false;
      var declValue = (0, _getDeclarationValue["default"])(decl);
      var parsedValue = (0, _postcssValueParser["default"])(declValue);
      parsedValue.walk(function (valueNode) {
        if (valueNode.type !== "function") {
          return;
        }
        if (!(0, _isStandardSyntaxFunction["default"])(valueNode)) {
          return;
        }
        var functionString = _postcssValueParser["default"].stringify(valueNode);
        var isMultiLine = !(0, _isSingleLineString["default"])(functionString);
        var containsNewline = function containsNewline( /** @type {string} */str) {
          return str.includes("\n");
        };

        // Check opening ...

        var openingIndex = valueNode.sourceIndex + valueNode.value.length + 1;
        var checkBefore = getCheckBefore(valueNode);
        if (primary === "always" && !containsNewline(checkBefore)) {
          if (context.fix) {
            hasFixed = true;
            fixBeforeForAlways(valueNode, context.newline || "");
          } else {
            complain(messages.expectedOpening, openingIndex);
          }
        }
        if (isMultiLine && primary === "always-multi-line" && !containsNewline(checkBefore)) {
          if (context.fix) {
            hasFixed = true;
            fixBeforeForAlways(valueNode, context.newline || "");
          } else {
            complain(messages.expectedOpeningMultiLine, openingIndex);
          }
        }
        if (isMultiLine && primary === "never-multi-line" && checkBefore !== "") {
          if (context.fix) {
            hasFixed = true;
            fixBeforeForNever(valueNode);
          } else {
            complain(messages.rejectedOpeningMultiLine, openingIndex);
          }
        }

        // Check closing ...

        var closingIndex = valueNode.sourceIndex + functionString.length - 2;
        var checkAfter = getCheckAfter(valueNode);
        if (primary === "always" && !containsNewline(checkAfter)) {
          if (context.fix) {
            hasFixed = true;
            fixAfterForAlways(valueNode, context.newline || "");
          } else {
            complain(messages.expectedClosing, closingIndex);
          }
        }
        if (isMultiLine && primary === "always-multi-line" && !containsNewline(checkAfter)) {
          if (context.fix) {
            hasFixed = true;
            fixAfterForAlways(valueNode, context.newline || "");
          } else {
            complain(messages.expectedClosingMultiLine, closingIndex);
          }
        }
        if (isMultiLine && primary === "never-multi-line" && checkAfter !== "") {
          if (context.fix) {
            hasFixed = true;
            fixAfterForNever(valueNode);
          } else {
            complain(messages.rejectedClosingMultiLine, closingIndex);
          }
        }
      });
      if (hasFixed) {
        (0, _setDeclarationValue["default"])(decl, parsedValue.toString());
      }

      /**
      	 * @param {string} message
      	 * @param {number} offset
      	 */
      function complain(message, offset) {
        (0, _report["default"])({
          ruleName: ruleName,
          result: result,
          message: message,
          node: decl,
          index: (0, _declarationValueIndex["default"])(decl) + offset
        });
      }
    });
  };
};

/** @typedef {import('postcss-value-parser').FunctionNode} FunctionNode */

/**
 * @param {FunctionNode} valueNode
 */
function getCheckBefore(valueNode) {
  var before = valueNode.before;
  var _iterator = _createForOfIteratorHelper(valueNode.nodes),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var node = _step.value;
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        before += node.value;
        continue;
      }
      break;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return before;
}

/**
 * @param {FunctionNode} valueNode
 */
function getCheckAfter(valueNode) {
  var after = "";
  var _iterator2 = _createForOfIteratorHelper(_toConsumableArray(valueNode.nodes).reverse()),
    _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
      var node = _step2.value;
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        after = node.value + after;
        continue;
      }
      break;
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  after += valueNode.after;
  return after;
}

/**
 * @param {FunctionNode} valueNode
 * @param {string} newline
 */
function fixBeforeForAlways(valueNode, newline) {
  var target;
  var _iterator3 = _createForOfIteratorHelper(valueNode.nodes),
    _step3;
  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var node = _step3.value;
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        target = node;
        continue;
      }
      break;
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }
  if (target) {
    target.value = newline + target.value;
  } else {
    valueNode.before = newline + valueNode.before;
  }
}

/**
 * @param {FunctionNode} valueNode
 */
function fixBeforeForNever(valueNode) {
  valueNode.before = "";
  var _iterator4 = _createForOfIteratorHelper(valueNode.nodes),
    _step4;
  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var node = _step4.value;
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        node.value = "";
        continue;
      }
      break;
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }
}

/**
 * @param {FunctionNode} valueNode
 * @param {string} newline
 */
function fixAfterForAlways(valueNode, newline) {
  valueNode.after = newline + valueNode.after;
}

/**
 * @param {FunctionNode} valueNode
 */
function fixAfterForNever(valueNode) {
  valueNode.after = "";
  var _iterator5 = _createForOfIteratorHelper(_toConsumableArray(valueNode.nodes).reverse()),
    _step5;
  try {
    for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
      var node = _step5.value;
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        node.value = "";
        continue;
      }
      break;
    }
  } catch (err) {
    _iterator5.e(err);
  } finally {
    _iterator5.f();
  }
}
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;