"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../../utils/getDeclarationValue.js"));
var _isSingleLineString = _interopRequireDefault(require("../../utils/isSingleLineString.js"));
var _isStandardSyntaxFunction = _interopRequireDefault(require("../../utils/isStandardSyntaxFunction.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _setDeclarationValue = _interopRequireDefault(require("../../utils/setDeclarationValue.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "function-parentheses-space-inside";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedOpening: "Expected single space after \"(\"",
  rejectedOpening: "Unexpected whitespace after \"(\"",
  expectedClosing: "Expected single space before \")\"",
  rejectedClosing: "Unexpected whitespace before \")\"",
  expectedOpeningSingleLine: "Expected single space after \"(\" in a single-line function",
  rejectedOpeningSingleLine: "Unexpected whitespace after \"(\" in a single-line function",
  expectedClosingSingleLine: "Expected single space before \")\" in a single-line function",
  rejectedClosingSingleLine: "Unexpected whitespace before \")\" in a single-line function"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/function-parentheses-space-inside/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never", "always-single-line", "never-single-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      if (!decl.value.includes("(")) {
        return;
      }
      var hasFixed = false;
      var declValue = (0, _getDeclarationValue["default"])(decl);
      var parsedValue = (0, _postcssValueParser["default"])(declValue);
      parsedValue.walk(function (valueNode) {
        if (valueNode.type !== "function") {
          return;
        }
        if (!(0, _isStandardSyntaxFunction["default"])(valueNode)) {
          return;
        }

        // Ignore function without parameters
        if (!valueNode.nodes.length) {
          return;
        }
        var functionString = _postcssValueParser["default"].stringify(valueNode);
        var isSingleLine = (0, _isSingleLineString["default"])(functionString);

        // Check opening ...

        var openingIndex = valueNode.sourceIndex + valueNode.value.length + 1;
        if (primary === "always" && valueNode.before !== " ") {
          if (context.fix) {
            hasFixed = true;
            valueNode.before = " ";
          } else {
            complain(messages.expectedOpening, openingIndex);
          }
        }
        if (primary === "never" && valueNode.before !== "") {
          if (context.fix) {
            hasFixed = true;
            valueNode.before = "";
          } else {
            complain(messages.rejectedOpening, openingIndex);
          }
        }
        if (isSingleLine && primary === "always-single-line" && valueNode.before !== " ") {
          if (context.fix) {
            hasFixed = true;
            valueNode.before = " ";
          } else {
            complain(messages.expectedOpeningSingleLine, openingIndex);
          }
        }
        if (isSingleLine && primary === "never-single-line" && valueNode.before !== "") {
          if (context.fix) {
            hasFixed = true;
            valueNode.before = "";
          } else {
            complain(messages.rejectedOpeningSingleLine, openingIndex);
          }
        }

        // Check closing ...

        var closingIndex = valueNode.sourceIndex + functionString.length - 2;
        if (primary === "always" && valueNode.after !== " ") {
          if (context.fix) {
            hasFixed = true;
            valueNode.after = " ";
          } else {
            complain(messages.expectedClosing, closingIndex);
          }
        }
        if (primary === "never" && valueNode.after !== "") {
          if (context.fix) {
            hasFixed = true;
            valueNode.after = "";
          } else {
            complain(messages.rejectedClosing, closingIndex);
          }
        }
        if (isSingleLine && primary === "always-single-line" && valueNode.after !== " ") {
          if (context.fix) {
            hasFixed = true;
            valueNode.after = " ";
          } else {
            complain(messages.expectedClosingSingleLine, closingIndex);
          }
        }
        if (isSingleLine && primary === "never-single-line" && valueNode.after !== "") {
          if (context.fix) {
            hasFixed = true;
            valueNode.after = "";
          } else {
            complain(messages.rejectedClosingSingleLine, closingIndex);
          }
        }
      });
      if (hasFixed) {
        (0, _setDeclarationValue["default"])(decl, parsedValue.toString());
      }

      /**
      	 * @param {string} message
      	 * @param {number} offset
      	 */
      function complain(message, offset) {
        (0, _report["default"])({
          ruleName: ruleName,
          result: result,
          message: message,
          node: decl,
          index: (0, _declarationValueIndex["default"])(decl) + offset
        });
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;