"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = functionCommaSpaceChecker;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _declarationValueIndex = _interopRequireDefault(require("../utils/declarationValueIndex.js"));
var _getDeclarationValue = _interopRequireDefault(require("../utils/getDeclarationValue.js"));
var _isStandardSyntaxFunction = _interopRequireDefault(require("../utils/isStandardSyntaxFunction.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
var _setDeclarationValue = _interopRequireDefault(require("../utils/setDeclarationValue.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/** @typedef {import('postcss-value-parser').Node} ValueParserNode */
/** @typedef {import('postcss-value-parser').DivNode} ValueParserDivNode */
/** @typedef {(args: { source: string, index: number, err: (message: string) => void }) => void} LocationChecker */
/**
 * @param {{
 *   root: import('postcss').Root,
 *   locationChecker: LocationChecker,
 *   fix: ((node: ValueParserDivNode, index: number, nodes: ValueParserNode[]) => boolean) | null,
 *   result: import('stylelint').PostcssResult,
 *   checkedRuleName: string,
 * }} opts
 */
function functionCommaSpaceChecker(opts) {
  opts.root.walkDecls(function (decl) {
    var declValue = (0, _getDeclarationValue["default"])(decl);
    var hasFixed;
    var parsedValue = (0, _postcssValueParser["default"])(declValue);
    parsedValue.walk(function (valueNode) {
      if (valueNode.type !== "function") {
        return;
      }
      if (!(0, _isStandardSyntaxFunction["default"])(valueNode)) {
        return;
      }

      // Ignore `url()` arguments, which may contain data URIs or other funky stuff
      if (valueNode.value.toLowerCase() === "url") {
        return;
      }
      var argumentStrings = valueNode.nodes.map(function (node) {
        return _postcssValueParser["default"].stringify(node);
      });
      var functionArguments = function () {
        // Remove function name and parens
        var result = valueNode.before + argumentStrings.join("") + valueNode.after;

        // 1. Remove comments including preceding whitespace (when only succeeded by whitespace)
        // 2. Remove all other comments, but leave adjacent whitespace intact
        // //eslint-disable-next-line regexp/no-dupe-disjunctions -- TODO: Possible to simplify the regex.
        result = result.replace(/( *\/(\*.*\*\/(?!\S)|\/.*)|(\/(\*.*\*\/|\/.*)))/, "");
        return result;
      }();

      /**
       * Gets the index of the comma for checking.
       * @param {ValueParserDivNode} commaNode The comma node
       * @param {number} nodeIndex The index of the comma node
       * @returns {number} The index of the comma for checking
       */
      var getCommaCheckIndex = function getCommaCheckIndex(commaNode, nodeIndex) {
        var commaBefore = valueNode.before + argumentStrings.slice(0, nodeIndex).join("") + commaNode.before;

        // 1. Remove comments including preceding whitespace (when only succeeded by whitespace)
        // 2. Remove all other comments, but leave adjacent whitespace intact
        // //eslint-disable-next-line regexp/no-dupe-disjunctions -- TODO: Possible to simplify the regex.
        commaBefore = commaBefore.replace(/( *\/(\*.*\*\/(?!\S)|\/.*)|(\/(\*.*\*\/|\/.*)))/, "");
        return commaBefore.length;
      };

      /** @type {{ commaNode: ValueParserDivNode, checkIndex: number, nodeIndex: number }[]} */
      var commaDataList = [];
      var _iterator = _createForOfIteratorHelper(valueNode.nodes.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            nodeIndex = _step$value[0],
            node = _step$value[1];
          if (node.type !== "div" || node.value !== ",") {
            continue;
          }
          var checkIndex = getCommaCheckIndex(node, nodeIndex);
          commaDataList.push({
            commaNode: node,
            checkIndex: checkIndex,
            nodeIndex: nodeIndex
          });
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      var _loop = function _loop() {
        var _commaDataList$_i = _commaDataList[_i],
          commaNode = _commaDataList$_i.commaNode,
          checkIndex = _commaDataList$_i.checkIndex,
          nodeIndex = _commaDataList$_i.nodeIndex;
        opts.locationChecker({
          source: functionArguments,
          index: checkIndex,
          err: function err(message) {
            var index = (0, _declarationValueIndex["default"])(decl) + commaNode.sourceIndex + commaNode.before.length;
            if (opts.fix && opts.fix(commaNode, nodeIndex, valueNode.nodes)) {
              hasFixed = true;
              return;
            }
            (0, _report["default"])({
              index: index,
              message: message,
              node: decl,
              result: opts.result,
              ruleName: opts.checkedRuleName
            });
          }
        });
      };
      for (var _i = 0, _commaDataList = commaDataList; _i < _commaDataList.length; _i++) {
        _loop();
      }
    });
    if (hasFixed) {
      (0, _setDeclarationValue["default"])(decl, parsedValue.toString());
    }
  });
}