"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = functionCommaSpaceFix;
/**
 * @param {{
 *   div: import('postcss-value-parser').DivNode,
 *   index: number,
 *   nodes: import('postcss-value-parser').Node[],
 *   expectation: string,
 *   position: 'before' | 'after',
 *   symb: string,
 * }} params
 * @returns {boolean}
 */
function functionCommaSpaceFix(params) {
  var div = params.div,
    index = params.index,
    nodes = params.nodes,
    expectation = params.expectation,
    position = params.position,
    symb = params.symb;
  if (expectation.startsWith("always")) {
    div[position] = symb;
    return true;
  }
  if (expectation.startsWith("never")) {
    div[position] = "";
    for (var i = index + 1; i < nodes.length; i++) {
      var node = nodes[i];
      if (node === undefined) {
        continue;
      }
      if (node.type === "comment") {
        continue;
      }
      if (node.type === "space") {
        node.value = "";
        continue;
      }
      break;
    }
    return true;
  }
  return false;
}