"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _beforeBlockString = _interopRequireDefault(require("../../utils/beforeBlockString.js"));
var _hasBlock = _interopRequireDefault(require("../../utils/hasBlock.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _typeGuards = require("../../utils/typeGuards.js");
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "indentation";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(x) {
    return "Expected indentation of ".concat(x);
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/indentation/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary) {
  var secondaryOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var context = arguments.length > 2 ? arguments[2] : undefined;
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: [_validateTypes.isNumber, "tab"]
    }, {
      actual: secondaryOptions,
      possible: {
        baseIndentLevel: [_validateTypes.isNumber, "auto"],
        except: ["block", "value", "param"],
        ignore: ["value", "param", "inside-parens"],
        indentInsideParens: ["twice", "once-at-root-twice-in-block"],
        indentClosingBrace: [_validateTypes.isBoolean]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }
    var spaceCount = (0, _validateTypes.isNumber)(primary) ? primary : null;
    var indentChar = spaceCount === null ? "\t" : " ".repeat(spaceCount);
    var warningWord = primary === "tab" ? "tab" : "space";

    /** @type {number | 'auto'} */
    var baseIndentLevel = secondaryOptions.baseIndentLevel;
    /** @type {boolean} */
    var indentClosingBrace = secondaryOptions.indentClosingBrace;

    /**
    	 * @param {number} level
    	 */
    var legibleExpectation = function legibleExpectation(level) {
      var count = spaceCount === null ? level : level * spaceCount;
      var quantifiedWarningWord = count === 1 ? warningWord : "".concat(warningWord, "s");
      return "".concat(count, " ").concat(quantifiedWarningWord);
    };

    // Cycle through all nodes using walk.
    root.walk(function (node) {
      if ((0, _typeGuards.isRoot)(node)) {
        // Ignore nested template literals root in css-in-js lang
        return;
      }
      var nodeLevel = indentationLevel(node);

      // Cut out any * and _ hacks from `before`
      var before = (node.raws.before || "").replace(/[*_]$/, "");
      var after = _typeof(node.raws.after) === "string" ? node.raws.after : "";
      var parent = node.parent;
      if (!parent) {
        throw new Error("A parent node must be present");
      }
      var expectedOpeningBraceIndentation = indentChar.repeat(nodeLevel);

      // Only inspect the spaces before the node
      // if this is the first node in root
      // or there is a newline in the `before` string.
      // (If there is no newline before a node,
      // there is no "indentation" to check.)
      var isFirstChild = parent.type === "root" && parent.first === node;
      var lastIndexOfNewline = before.lastIndexOf("\n");

      // Inspect whitespace in the `before` string that is
      // *after* the *last* newline character,
      // because anything besides that is not indentation for this node:
      // it is some other kind of separation, checked by some separate rule
      if ((lastIndexOfNewline !== -1 || isFirstChild && (!getDocument(parent) || parent.raws.codeBefore && parent.raws.codeBefore.endsWith("\n"))) && before.slice(lastIndexOfNewline + 1) !== expectedOpeningBraceIndentation) {
        if (context.fix) {
          if (isFirstChild && (0, _validateTypes.isString)(node.raws.before)) {
            node.raws.before = node.raws.before.replace(/^[ \t]*(?=\S|$)/, expectedOpeningBraceIndentation);
          }
          node.raws.before = fixIndentation(node.raws.before, expectedOpeningBraceIndentation);
        } else {
          (0, _report["default"])({
            message: messages.expected(legibleExpectation(nodeLevel)),
            node: node,
            result: result,
            ruleName: ruleName
          });
        }
      }

      // Only blocks have the `after` string to check.
      // Only inspect `after` strings that start with a newline;
      // otherwise there's no indentation involved.
      // And check `indentClosingBrace` to see if it should be indented an extra level.
      var closingBraceLevel = indentClosingBrace ? nodeLevel + 1 : nodeLevel;
      var expectedClosingBraceIndentation = indentChar.repeat(closingBraceLevel);
      if (((0, _typeGuards.isRule)(node) || (0, _typeGuards.isAtRule)(node)) && (0, _hasBlock["default"])(node) && after && after.includes("\n") && after.slice(after.lastIndexOf("\n") + 1) !== expectedClosingBraceIndentation) {
        if (context.fix) {
          node.raws.after = fixIndentation(node.raws.after, expectedClosingBraceIndentation);
        } else {
          (0, _report["default"])({
            message: messages.expected(legibleExpectation(closingBraceLevel)),
            node: node,
            index: node.toString().length - 1,
            result: result,
            ruleName: ruleName
          });
        }
      }

      // If this is a declaration, check the value
      if ((0, _typeGuards.isDeclaration)(node)) {
        checkValue(node, nodeLevel);
      }

      // If this is a rule, check the selector
      if ((0, _typeGuards.isRule)(node)) {
        checkSelector(node, nodeLevel);
      }

      // If this is an at rule, check the params
      if ((0, _typeGuards.isAtRule)(node)) {
        checkAtRuleParams(node, nodeLevel);
      }
    });

    /**
    	 * @param {import('postcss').Node} node
    	 * @param {number} level
    	 * @returns {number}
    	 */
    function indentationLevel(node) {
      var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      if (!node.parent) {
        throw new Error("A parent node must be present");
      }
      if ((0, _typeGuards.isRoot)(node.parent)) {
        return level + getRootBaseIndentLevel(node.parent, baseIndentLevel, primary);
      }
      var calculatedLevel;

      // Indentation level equals the ancestor nodes
      // separating this node from root; so recursively
      // run this operation
      calculatedLevel = indentationLevel(node.parent, level + 1);

      // If `secondaryOptions.except` includes "block",
      // blocks are taken down one from their calculated level
      // (all blocks are the same level as their parents)
      if ((0, _optionsMatches["default"])(secondaryOptions, "except", "block") && ((0, _typeGuards.isRule)(node) || (0, _typeGuards.isAtRule)(node)) && (0, _hasBlock["default"])(node)) {
        calculatedLevel--;
      }
      return calculatedLevel;
    }

    /**
    	 * @param {import('postcss').Declaration} decl
    	 * @param {number} declLevel
    	 */
    function checkValue(decl, declLevel) {
      if (!decl.value.includes("\n")) {
        return;
      }
      if ((0, _optionsMatches["default"])(secondaryOptions, "ignore", "value")) {
        return;
      }
      var declString = decl.toString();
      var valueLevel = (0, _optionsMatches["default"])(secondaryOptions, "except", "value") ? declLevel : declLevel + 1;
      checkMultilineBit(declString, valueLevel, decl);
    }

    /**
    	 * @param {import('postcss').Rule} ruleNode
    	 * @param {number} ruleLevel
    	 */
    function checkSelector(ruleNode, ruleLevel) {
      var selector = ruleNode.selector;

      // Less mixins have params, and they should be indented extra
      // @ts-expect-error -- TS2339: Property 'params' does not exist on type 'Rule'.
      if (ruleNode.params) {
        ruleLevel += 1;
      }
      checkMultilineBit(selector, ruleLevel, ruleNode);
    }

    /**
    	 * @param {import('postcss').AtRule} atRule
    	 * @param {number} ruleLevel
    	 */
    function checkAtRuleParams(atRule, ruleLevel) {
      if ((0, _optionsMatches["default"])(secondaryOptions, "ignore", "param")) {
        return;
      }

      // @nest and SCSS's @at-root rules should be treated like regular rules, not expected
      // to have their params (selectors) indented
      var paramLevel = (0, _optionsMatches["default"])(secondaryOptions, "except", "param") || atRule.name === "nest" || atRule.name === "at-root" ? ruleLevel : ruleLevel + 1;
      checkMultilineBit((0, _beforeBlockString["default"])(atRule).trim(), paramLevel, atRule);
    }

    /**
    	 * @param {string} source
    	 * @param {number} newlineIndentLevel
    	 * @param {import('postcss').Node} node
    	 */
    function checkMultilineBit(source, newlineIndentLevel, node) {
      if (!source.includes("\n")) {
        return;
      }

      // Data for current node fixing
      /** @type {Array<{ expectedIndentation: string, currentIndentation: string, startIndex: number }>} */
      var fixPositions = [];

      // `outsideParens` because function arguments and also non-standard parenthesized stuff like
      // Sass maps are ignored to allow for arbitrary indentation
      var parentheticalDepth = 0;
      var ignoreInsideParans = (0, _optionsMatches["default"])(secondaryOptions, "ignore", "inside-parens");
      (0, _styleSearch["default"])({
        source: source,
        target: "\n",
        // @ts-expect-error -- The `outsideParens` option is unsupported. Why?
        outsideParens: ignoreInsideParans
      }, function (match, matchCount) {
        var precedesClosingParenthesis = /^[ \t]*\)/.test(source.slice(match.startIndex + 1));
        if (ignoreInsideParans && (precedesClosingParenthesis || match.insideParens)) {
          return;
        }
        var expectedIndentLevel = newlineIndentLevel;

        // Modififications for parenthetical content
        if (!ignoreInsideParans && match.insideParens) {
          // If the first match in is within parentheses, reduce the parenthesis penalty
          if (matchCount === 1) {
            parentheticalDepth -= 1;
          }

          // Account for windows line endings
          var newlineIndex = match.startIndex;
          if (source[match.startIndex - 1] === "\r") {
            newlineIndex--;
          }
          var followsOpeningParenthesis = /\([ \t]*$/.test(source.slice(0, newlineIndex));
          if (followsOpeningParenthesis) {
            parentheticalDepth += 1;
          }
          var followsOpeningBrace = /\{[ \t]*$/.test(source.slice(0, newlineIndex));
          if (followsOpeningBrace) {
            parentheticalDepth += 1;
          }
          var startingClosingBrace = /^[ \t]*\}/.test(source.slice(match.startIndex + 1));
          if (startingClosingBrace) {
            parentheticalDepth -= 1;
          }
          expectedIndentLevel += parentheticalDepth;

          // Past this point, adjustments to parentheticalDepth affect next line

          if (precedesClosingParenthesis) {
            parentheticalDepth -= 1;
          }
          switch (secondaryOptions.indentInsideParens) {
            case "twice":
              if (!precedesClosingParenthesis || indentClosingBrace) {
                expectedIndentLevel += 1;
              }
              break;
            case "once-at-root-twice-in-block":
              if (node.parent === node.root()) {
                if (precedesClosingParenthesis && !indentClosingBrace) {
                  expectedIndentLevel -= 1;
                }
                break;
              }
              if (!precedesClosingParenthesis || indentClosingBrace) {
                expectedIndentLevel += 1;
              }
              break;
            default:
              if (precedesClosingParenthesis && !indentClosingBrace) {
                expectedIndentLevel -= 1;
              }
          }
        }

        // Starting at the index after the newline, we want to
        // check that the whitespace characters (excluding newlines) before the first
        // non-whitespace character equal the expected indentation
        var afterNewlineSpaceMatches = /^([ \t]*)\S/.exec(source.slice(match.startIndex + 1));
        if (!afterNewlineSpaceMatches) {
          return;
        }
        var afterNewlineSpace = afterNewlineSpaceMatches[1] || "";
        var expectedIndentation = indentChar.repeat(expectedIndentLevel > 0 ? expectedIndentLevel : 0);
        if (afterNewlineSpace !== expectedIndentation) {
          if (context.fix) {
            // Adding fixes position in reverse order, because if we change indent in the beginning of the string it will break all following fixes for that string
            fixPositions.unshift({
              expectedIndentation: expectedIndentation,
              currentIndentation: afterNewlineSpace,
              startIndex: match.startIndex
            });
          } else {
            (0, _report["default"])({
              message: messages.expected(legibleExpectation(expectedIndentLevel)),
              node: node,
              index: match.startIndex + afterNewlineSpace.length + 1,
              result: result,
              ruleName: ruleName
            });
          }
        }
      });
      if (fixPositions.length) {
        if ((0, _typeGuards.isRule)(node)) {
          var _iterator = _createForOfIteratorHelper(fixPositions),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var fixPosition = _step.value;
              node.selector = replaceIndentation(node.selector, fixPosition.currentIndentation, fixPosition.expectedIndentation, fixPosition.startIndex);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
        if ((0, _typeGuards.isDeclaration)(node)) {
          var declProp = node.prop;
          var declBetween = node.raws.between;
          if (!(0, _validateTypes.isString)(declBetween)) {
            throw new TypeError("The `between` property must be a string");
          }
          var _iterator2 = _createForOfIteratorHelper(fixPositions),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var _fixPosition = _step2.value;
              if (_fixPosition.startIndex < declProp.length + declBetween.length) {
                node.raws.between = replaceIndentation(declBetween, _fixPosition.currentIndentation, _fixPosition.expectedIndentation, _fixPosition.startIndex - declProp.length);
              } else {
                node.value = replaceIndentation(node.value, _fixPosition.currentIndentation, _fixPosition.expectedIndentation, _fixPosition.startIndex - declProp.length - declBetween.length);
              }
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        }
        if ((0, _typeGuards.isAtRule)(node)) {
          var atRuleName = node.name;
          var atRuleAfterName = node.raws.afterName;
          var atRuleParams = node.params;
          if (!(0, _validateTypes.isString)(atRuleAfterName)) {
            throw new TypeError("The `afterName` property must be a string");
          }
          var _iterator3 = _createForOfIteratorHelper(fixPositions),
            _step3;
          try {
            for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
              var _fixPosition2 = _step3.value;
              // 1 — it's a @ length
              if (_fixPosition2.startIndex < 1 + atRuleName.length + atRuleAfterName.length) {
                node.raws.afterName = replaceIndentation(atRuleAfterName, _fixPosition2.currentIndentation, _fixPosition2.expectedIndentation, _fixPosition2.startIndex - atRuleName.length - 1);
              } else {
                node.params = replaceIndentation(atRuleParams, _fixPosition2.currentIndentation, _fixPosition2.expectedIndentation, _fixPosition2.startIndex - atRuleName.length - atRuleAfterName.length - 1);
              }
            }
          } catch (err) {
            _iterator3.e(err);
          } finally {
            _iterator3.f();
          }
        }
      }
    }
  };
};

/**
 * @param {import('postcss').Root} root
 * @param {number | 'auto'} baseIndentLevel
 * @param {string} space
 * @returns {number}
 */
function getRootBaseIndentLevel(root, baseIndentLevel, space) {
  var document = getDocument(root);
  if (!document) {
    return 0;
  }
  if (!root.source) {
    throw new Error("The root node must have a source");
  }

  /** @type {import('postcss').Source & { baseIndentLevel?: number }} */
  var source = root.source;
  var indentLevel = source.baseIndentLevel;
  if ((0, _validateTypes.isNumber)(indentLevel) && Number.isSafeInteger(indentLevel)) {
    return indentLevel;
  }
  var newIndentLevel = inferRootIndentLevel(root, baseIndentLevel, function () {
    return inferDocIndentSize(document, space);
  });
  source.baseIndentLevel = newIndentLevel;
  return newIndentLevel;
}

/**
 * @param {import('postcss').Node} node
 */
function getDocument(node) {
  // @ts-expect-error -- TS2339: Property 'document' does not exist on type 'Node'.
  var document = node.document;
  if (document) {
    return document;
  }
  var root = node.root();

  // @ts-expect-error -- TS2339: Property 'document' does not exist on type 'Node'.
  return root && root.document;
}

/**
 * @param {import('postcss').Document} document
 * @param {string} space
 * returns {number}
 */
function inferDocIndentSize(document, space) {
  if (!document.source) {
    throw new Error("The document node must have a source");
  }

  /** @type {import('postcss').Source & { indentSize?: number }} */
  var docSource = document.source;
  var indentSize = docSource.indentSize;
  if ((0, _validateTypes.isNumber)(indentSize) && Number.isSafeInteger(indentSize)) {
    return indentSize;
  }
  var source = document.source.input.css;
  var indents = source.match(/^ *(?=\S)/gm);
  if (indents) {
    /** @type {Map<number, number>} */
    var scores = new Map();
    var lastIndentSize = 0;
    var lastLeadingSpacesLength = 0;

    /**
     * @param {number} leadingSpacesLength
     */
    var vote = function vote(leadingSpacesLength) {
      if (leadingSpacesLength) {
        lastIndentSize = Math.abs(leadingSpacesLength - lastLeadingSpacesLength) || lastIndentSize;
        if (lastIndentSize > 1) {
          var score = scores.get(lastIndentSize);
          if (score) {
            scores.set(lastIndentSize, score + 1);
          } else {
            scores.set(lastIndentSize, 1);
          }
        }
      } else {
        lastIndentSize = 0;
      }
      lastLeadingSpacesLength = leadingSpacesLength;
    };
    var _iterator4 = _createForOfIteratorHelper(indents),
      _step4;
    try {
      for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
        var leadingSpaces = _step4.value;
        vote(leadingSpaces.length);
      }
    } catch (err) {
      _iterator4.e(err);
    } finally {
      _iterator4.f();
    }
    var bestScore = 0;
    var _iterator5 = _createForOfIteratorHelper(scores.entries()),
      _step5;
    try {
      for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
        var _step5$value = _slicedToArray(_step5.value, 2),
          indentSizeDate = _step5$value[0],
          score = _step5$value[1];
        if (score > bestScore) {
          bestScore = score;
          indentSize = indentSizeDate;
        }
      }
    } catch (err) {
      _iterator5.e(err);
    } finally {
      _iterator5.f();
    }
  }
  indentSize = Number(indentSize) || indents && indents[0] && indents[0].length || Number(space) || 2;
  docSource.indentSize = indentSize;
  return indentSize;
}

/**
 * @param {import('postcss').Root} root
 * @param {number | 'auto'} baseIndentLevel
 * @param {() => number} indentSize
 * @returns {number}
 */
function inferRootIndentLevel(root, baseIndentLevel, indentSize) {
  /**
   * @param {string} indent
   */
  function getIndentLevel(indent) {
    var tabMatch = indent.match(/\t/g);
    var tabCount = tabMatch ? tabMatch.length : 0;
    var spaceMatch = indent.match(/ /g);
    var spaceCount = spaceMatch ? Math.round(spaceMatch.length / indentSize()) : 0;
    return tabCount + spaceCount;
  }
  var newBaseIndentLevel = 0;
  if (!(0, _validateTypes.isNumber)(baseIndentLevel) || !Number.isSafeInteger(baseIndentLevel)) {
    if (!root.source) {
      throw new Error("The root node must have a source");
    }
    var source = root.source.input.css;
    source = source.replace(/^[^\r\n]+/, function (firstLine) {
      var match = root.raws.codeBefore && /(?:^|\n)([ \t]*)$/.exec(root.raws.codeBefore);
      if (match) {
        return match[1] + firstLine;
      }
      return "";
    });
    var indentions = source.match(/^[ \t]*(?=\S)/gm);
    if (indentions) {
      return Math.min.apply(Math, _toConsumableArray(indentions.map(function (indent) {
        return getIndentLevel(indent);
      })));
    }
    newBaseIndentLevel = 1;
  } else {
    newBaseIndentLevel = baseIndentLevel;
  }
  var indents = [];
  var foundIndents = root.raws.codeBefore && /(?:^|\n)([ \t]*)\S/m.exec(root.raws.codeBefore);

  // The indent level of the CSS code block in non-CSS-like files is determined by the shortest indent of non-empty line.
  if (foundIndents) {
    var shortest = Number.MAX_SAFE_INTEGER;
    var i = 0;
    while (++i < foundIndents.length) {
      var foundIndent = foundIndents[i];
      (0, _validateTypes.assertString)(foundIndent);
      var current = getIndentLevel(foundIndent);
      if (current < shortest) {
        shortest = current;
        if (shortest === 0) {
          break;
        }
      }
    }
    if (shortest !== Number.MAX_SAFE_INTEGER) {
      indents.push(new Array(shortest).fill(" ").join(""));
    }
  }
  var after = root.raws.after;
  if (after) {
    var afterEnd;
    if (after.endsWith("\n")) {
      // @ts-expect-error -- TS2339: Property 'document' does not exist on type 'Root'.
      var document = root.document;
      if (document) {
        var nextRoot = document.nodes[document.nodes.indexOf(root) + 1];
        afterEnd = nextRoot ? nextRoot.raws.codeBefore : document.raws.codeAfter;
      } else {
        // Nested root node in css-in-js lang
        var parent = root.parent;
        if (!parent) {
          throw new Error("The root node must have a parent");
        }
        var _nextRoot = parent.nodes[parent.nodes.indexOf(root) + 1];
        afterEnd = _nextRoot ? _nextRoot.raws.codeBefore : root.raws.codeAfter;
      }
    } else {
      afterEnd = after;
    }
    if (afterEnd) {
      indents.push(afterEnd.match(/^[ \t]*/)[0]);
    }
  }
  if (indents.length) {
    return Math.max.apply(Math, _toConsumableArray(indents.map(function (indent) {
      return getIndentLevel(indent);
    }))) + newBaseIndentLevel;
  }
  return newBaseIndentLevel;
}

/**
 * @param {string | undefined} str
 * @param {string} whitespace
 */
function fixIndentation(str, whitespace) {
  if (!(0, _validateTypes.isString)(str)) {
    return str;
  }
  return str.replace(/\n[ \t]*(?=\S|$)/g, "\n".concat(whitespace));
}

/**
 * @param {string} input
 * @param {string} searchString
 * @param {string} replaceString
 * @param {number} startIndex
 */
function replaceIndentation(input, searchString, replaceString, startIndex) {
  var offset = startIndex + 1;
  var stringStart = input.slice(0, offset);
  var stringEnd = input.slice(offset + searchString.length);
  return stringStart + replaceString + stringEnd;
}
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;