"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcss = require("postcss");
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "linebreaks";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(linebreak) {
    return "Expected linebreak to be ".concat(linebreak);
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/linebreaks/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["unix", "windows"]
    });
    if (!validOptions) {
      return;
    }
    var shouldHaveCR = primary === "windows";
    if (context.fix) {
      root.walk(function (node) {
        if ("selector" in node) {
          node.selector = fixData(node.selector);
        }
        if ("value" in node) {
          node.value = fixData(node.value);
        }
        if ("text" in node) {
          node.text = fixData(node.text);
        }
        if (node.raws.before) {
          node.raws.before = fixData(node.raws.before);
        }
        if (_typeof(node.raws.after) === "string") {
          node.raws.after = fixData(node.raws.after);
        }
      });
      if (_typeof(root.raws.after) === "string") {
        root.raws.after = fixData(root.raws.after);
      }
    } else {
      if (root.source === null) {
        throw new Error("The root node must have a source");
      }
      var lines = root.source.input.css.split("\n");
      var _iterator = _createForOfIteratorHelper(lines.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            i = _step$value[0],
            line = _step$value[1];
          if (i < lines.length - 1 && !line.includes("\r")) {
            line += "\n";
          }
          if (hasError(line)) {
            var lineNum = i + 1;
            var colNum = line.length;
            reportNewlineError(lineNum, colNum);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
    	 * @param {string} dataToCheck
    	 */
    function hasError(dataToCheck) {
      var hasNewlineToVerify = /[\r\n]/.test(dataToCheck);
      var hasCR = hasNewlineToVerify ? /\r/.test(dataToCheck) : false;
      return hasNewlineToVerify && hasCR !== shouldHaveCR;
    }

    /**
    	 * @param {string} data
    	 */
    function fixData(data) {
      if (data) {
        var res = data.replace(/\r/g, "");
        if (shouldHaveCR) {
          res = res.replace(/\n/g, "\r\n");
        }
        return res;
      }
      return data;
    }

    /**
    	 * @param {number} line
    	 * @param {number} column
    	 */
    function reportNewlineError(line, column) {
      // Creating a node manually helps us to point to empty lines.
      var node = (0, _postcss.rule)({
        source: {
          start: {
            line: line,
            column: column,
            offset: 0
          },
          input: new _postcss.Input("")
        }
      });
      (0, _report["default"])({
        message: messages.expected(primary),
        node: node,
        result: result,
        ruleName: ruleName
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;