"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _validateTypes = require("../../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "max-line-length";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(max) {
    return "Expected line length to be no more than ".concat(max, " ").concat(max === 1 ? "character" : "characters");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/max-line-length/README.md"
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: _validateTypes.isNumber
    }, {
      actual: secondaryOptions,
      possible: {
        ignore: ["non-comments", "comments"],
        ignorePattern: [_validateTypes.isString, _validateTypes.isRegExp]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }
    if (root.source === null) {
      throw new Error("The root node must have a source");
    }
    var EXCLUDED_PATTERNS = [/url\(\s*(\S.*\S)\s*\)/gi,
    // allow tab, whitespace in url content
    /@import\s+(['"].*['"])/gi];
    var ignoreNonComments = (0, _optionsMatches["default"])(secondaryOptions, "ignore", "non-comments");
    var ignoreComments = (0, _optionsMatches["default"])(secondaryOptions, "ignore", "comments");
    var rootString = context.fix ? root.toString() : root.source.input.css;
    // Array of skipped sub strings, i.e `url(...)`, `@import "..."`
    /** @type {Array<[number, number]>} */
    var skippedSubStrings = [];
    var skippedSubStringsIndex = 0;
    for (var _i = 0, _EXCLUDED_PATTERNS = EXCLUDED_PATTERNS; _i < _EXCLUDED_PATTERNS.length; _i++) {
      var pattern = _EXCLUDED_PATTERNS[_i];
      var _iterator = _createForOfIteratorHelper(rootString.matchAll(pattern)),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var match = _step.value;
          var subMatch = match[1] || "";
          var startOfSubString = (match.index || 0) + (match[0] || "").indexOf(subMatch);
          skippedSubStrings.push([startOfSubString, startOfSubString + subMatch.length]);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
    skippedSubStrings = skippedSubStrings.sort(function (a, b) {
      return a[0] - b[0];
    });

    // Check first line
    checkNewline({
      endIndex: 0
    });
    // Check subsequent lines
    (0, _styleSearch["default"])({
      source: rootString,
      target: ["\n"],
      comments: "check"
    }, function (match) {
      return checkNewline(match);
    });

    /**
    	 * @param {number} index
    	 */
    function complain(index) {
      (0, _report["default"])({
        index: index,
        result: result,
        ruleName: ruleName,
        message: messages.expected(primary),
        node: root
      });
    }

    /**
    	 * @param {number} start
    	 * @param {number} end
    	 */
    function tryToPopSubString(start, end) {
      var skippedSubString = skippedSubStrings[skippedSubStringsIndex];
      (0, _validateTypes.assert)(skippedSubString);
      var _skippedSubString = _slicedToArray(skippedSubString, 2),
        startSubString = _skippedSubString[0],
        endSubString = _skippedSubString[1];

      // Excluded substring does not presented in current line
      if (end < startSubString) {
        return 0;
      }

      // Compute excluded substring size regarding to current line indexes
      var excluded = Math.min(end, endSubString) - Math.max(start, startSubString);

      // Current substring is out of range for next lines
      if (endSubString <= end) {
        skippedSubStringsIndex++;
      }
      return excluded;
    }

    /**
    	 * @param {import('style-search').StyleSearchMatch | { endIndex: number }} match
    	 */
    function checkNewline(match) {
      var nextNewlineIndex = rootString.indexOf("\n", match.endIndex);
      if (rootString[nextNewlineIndex - 1] === "\r") {
        nextNewlineIndex -= 1;
      }

      // Accommodate last line
      if (nextNewlineIndex === -1) {
        nextNewlineIndex = rootString.length;
      }
      var rawLineLength = nextNewlineIndex - match.endIndex;
      var excludedLength = skippedSubStrings[skippedSubStringsIndex] ? tryToPopSubString(match.endIndex, nextNewlineIndex) : 0;
      var lineText = rootString.slice(match.endIndex, nextNewlineIndex);

      // Case sensitive ignorePattern match
      if ((0, _optionsMatches["default"])(secondaryOptions, "ignorePattern", lineText)) {
        return;
      }

      // If the line's length is less than or equal to the specified
      // max, ignore it ... So anything below is liable to be complained about.
      // **Note that the length of any url arguments or import urls
      // are excluded from the calculation.**
      if (rawLineLength - excludedLength <= primary) {
        return;
      }
      var complaintIndex = nextNewlineIndex - 1;
      if (ignoreComments) {
        if ("insideComment" in match && match.insideComment) {
          return;
        }

        // This trimming business is to notice when the line starts a
        // comment but that comment is indented, e.g.
        //       /* something here */
        var nextTwoChars = rootString.slice(match.endIndex).trim().slice(0, 2);
        if (nextTwoChars === "/*" || nextTwoChars === "//") {
          return;
        }
      }
      if (ignoreNonComments) {
        if ("insideComment" in match && match.insideComment) {
          return complain(complaintIndex);
        }

        // This trimming business is to notice when the line starts a
        // comment but that comment is indented, e.g.
        //       /* something here */
        var _nextTwoChars = rootString.slice(match.endIndex).trim().slice(0, 2);
        if (_nextTwoChars !== "/*" && _nextTwoChars !== "//") {
          return;
        }
        return complain(complaintIndex);
      }

      // If there are no spaces besides initial (indent) spaces, ignore it
      var lineString = rootString.slice(match.endIndex, nextNewlineIndex);
      if (!lineString.replace(/^\s+/, "").includes(" ")) {
        return;
      }
      return complain(complaintIndex);
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;