"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssMediaQueryParser = _interopRequireDefault(require("postcss-media-query-parser"));
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _isCustomMediaQuery = _interopRequireDefault(require("../../utils/isCustomMediaQuery.js"));
var _isRangeContextMediaFeature = _interopRequireDefault(require("../../utils/isRangeContextMediaFeature.js"));
var _isStandardSyntaxMediaFeatureName = _interopRequireDefault(require("../../utils/isStandardSyntaxMediaFeatureName.js"));
var _rangeContextNodeParser = _interopRequireDefault(require("../rangeContextNodeParser.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "media-feature-name-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/media-feature-name-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(/^media$/i, function (atRule) {
      var hasComments = atRule.raws.params && atRule.raws.params.raw;
      var mediaRule = hasComments ? hasComments : atRule.params;
      (0, _postcssMediaQueryParser["default"])(mediaRule).walk(/^media-feature$/i, function (mediaFeatureNode) {
        var parent = mediaFeatureNode.parent;
        var mediaFeatureRangeContext = (0, _isRangeContextMediaFeature["default"])(parent.value);
        var value;
        var sourceIndex;
        if (mediaFeatureRangeContext) {
          var parsedRangeContext = (0, _rangeContextNodeParser["default"])(mediaFeatureNode);
          value = parsedRangeContext.name.value;
          sourceIndex = parsedRangeContext.name.sourceIndex;
        } else {
          value = mediaFeatureNode.value;
          sourceIndex = mediaFeatureNode.sourceIndex;
        }
        if (!(0, _isStandardSyntaxMediaFeatureName["default"])(value) || (0, _isCustomMediaQuery["default"])(value)) {
          return;
        }
        var expectedFeatureName = primary === "lower" ? value.toLowerCase() : value.toUpperCase();
        if (value === expectedFeatureName) {
          return;
        }
        if (context.fix) {
          if (hasComments) {
            hasComments = hasComments.slice(0, sourceIndex) + expectedFeatureName + hasComments.slice(sourceIndex + expectedFeatureName.length);
            if (atRule.raws.params === null) {
              throw new Error("The `AtRuleRaws` node must have a `params` property");
            }
            atRule.raws.params.raw = hasComments;
          } else {
            atRule.params = atRule.params.slice(0, sourceIndex) + expectedFeatureName + atRule.params.slice(sourceIndex + expectedFeatureName.length);
          }
          return;
        }
        (0, _report["default"])({
          index: (0, _atRuleParamIndex["default"])(atRule) + sourceIndex,
          message: messages.expected(value, expectedFeatureName),
          node: atRule,
          ruleName: ruleName,
          result: result
        });
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;