"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "media-feature-parentheses-space-inside";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedOpening: "Expected single space after \"(\"",
  rejectedOpening: "Unexpected whitespace after \"(\"",
  expectedClosing: "Expected single space before \")\"",
  rejectedClosing: "Unexpected whitespace before \")\""
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/media-feature-parentheses-space-inside/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(/^media$/i, function (atRule) {
      // If there are comments in the params, the complete string
      // will be at atRule.raws.params.raw
      var params = atRule.raws.params && atRule.raws.params.raw || atRule.params;
      var indexBoost = (0, _atRuleParamIndex["default"])(atRule);
      /** @type {Array<{ message: string, index: number }>} */
      var problems = [];
      var parsedParams = (0, _postcssValueParser["default"])(params).walk(function (node) {
        if (node.type === "function") {
          var len = _postcssValueParser["default"].stringify(node).length;
          if (primary === "never") {
            if (/[ \t]/.test(node.before)) {
              if (context.fix) {
                node.before = "";
              }
              problems.push({
                message: messages.rejectedOpening,
                index: node.sourceIndex + 1 + indexBoost
              });
            }
            if (/[ \t]/.test(node.after)) {
              if (context.fix) {
                node.after = "";
              }
              problems.push({
                message: messages.rejectedClosing,
                index: node.sourceIndex - 2 + len + indexBoost
              });
            }
          } else if (primary === "always") {
            if (node.before === "") {
              if (context.fix) {
                node.before = " ";
              }
              problems.push({
                message: messages.expectedOpening,
                index: node.sourceIndex + 1 + indexBoost
              });
            }
            if (node.after === "") {
              if (context.fix) {
                node.after = " ";
              }
              problems.push({
                message: messages.expectedClosing,
                index: node.sourceIndex - 2 + len + indexBoost
              });
            }
          }
        }
      });
      if (problems.length) {
        if (context.fix) {
          atRule.params = parsedParams.toString();
          return;
        }
        var _iterator = _createForOfIteratorHelper(problems),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var err = _step.value;
            (0, _report["default"])({
              message: err.message,
              node: atRule,
              index: err.index,
              result: result,
              ruleName: ruleName
            });
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;