"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _findMediaOperator = _interopRequireDefault(require("../findMediaOperator.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "media-feature-range-operator-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected single space after range operator";
  },
  rejectedAfter: function rejectedAfter() {
    return "Unexpected whitespace after range operator";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/media-feature-range-operator-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(/^media$/i, function (atRule) {
      /** @type {number[]} */
      var fixOperatorIndices = [];
      /** @type {((index: number) => void) | null} */
      var fix = context.fix ? function (index) {
        return fixOperatorIndices.push(index);
      } : null;
      (0, _findMediaOperator["default"])(atRule, function (match, params, node) {
        checkAfterOperator(match, params, node, fix);
      });
      if (fixOperatorIndices.length) {
        var params = atRule.raws.params ? atRule.raws.params.raw : atRule.params;
        var _iterator = _createForOfIteratorHelper(fixOperatorIndices.sort(function (a, b) {
            return b - a;
          })),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var index = _step.value;
            var beforeOperator = params.slice(0, index + 1);
            var afterOperator = params.slice(index + 1);
            if (primary === "always") {
              params = beforeOperator + afterOperator.replace(/^\s*/, " ");
            } else if (primary === "never") {
              params = beforeOperator + afterOperator.replace(/^\s*/, "");
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        if (atRule.raws.params) {
          atRule.raws.params.raw = params;
        } else {
          atRule.params = params;
        }
      }
    });

    /**
     * @param {import('style-search').StyleSearchMatch} match
     * @param {string} params
     * @param {import('postcss').AtRule} node
     * @param {((index: number) => void) | null} fix
     */
    function checkAfterOperator(match, params, node, fix) {
      var endIndex = match.startIndex + match.target.length - 1;
      checker.after({
        source: params,
        index: endIndex,
        err: function err(m) {
          if (fix) {
            fix(endIndex);
            return;
          }
          (0, _report["default"])({
            message: m,
            node: node,
            index: endIndex + (0, _atRuleParamIndex["default"])(node) + 1,
            result: result,
            ruleName: ruleName
          });
        }
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;