"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = mediaFeatureColonSpaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _atRuleParamIndex = _interopRequireDefault(require("../utils/atRuleParamIndex.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   locationChecker: (args: { source: string, index: number, err: (message: string) => void }) => void,
 *   fix: ((node: import('postcss').AtRule, index: number) => boolean) | null,
 *   result: import('stylelint').PostcssResult,
 *   checkedRuleName: string,
 * }} opts
 */
function mediaFeatureColonSpaceChecker(opts) {
  opts.root.walkAtRules(/^media$/i, function (atRule) {
    var params = atRule.raws.params ? atRule.raws.params.raw : atRule.params;
    (0, _styleSearch["default"])({
      source: params,
      target: ":"
    }, function (match) {
      checkColon(params, match.startIndex, atRule);
    });
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {import('postcss').AtRule} node
   */
  function checkColon(source, index, node) {
    opts.locationChecker({
      source: source,
      index: index,
      err: function err(message) {
        var colonIndex = index + (0, _atRuleParamIndex["default"])(node);
        if (opts.fix && opts.fix(node, colonIndex)) {
          return;
        }
        (0, _report["default"])({
          message: message,
          node: node,
          index: colonIndex,
          result: opts.result,
          ruleName: opts.checkedRuleName
        });
      }
    });
  }
}