"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = mediaQueryListCommaWhitespaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _atRuleParamIndex = _interopRequireDefault(require("../utils/atRuleParamIndex.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
var _validateTypes = require("../utils/validateTypes.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   result: import('stylelint').PostcssResult,
 *   locationChecker: (args: { source: string, index: number, err: (message: string) => void }) => void,
 *   checkedRuleName: string,
 *   fix?: ((atRule: import('postcss').AtRule, index: number) => boolean) | null | undefined,
 *   allowTrailingComments?: boolean,
 * }} opts
 */
function mediaQueryListCommaWhitespaceChecker(opts) {
  opts.root.walkAtRules(/^media$/i, function (atRule) {
    var params = atRule.raws.params ? atRule.raws.params.raw : atRule.params;
    (0, _styleSearch["default"])({
      source: params,
      target: ","
    }, function (match) {
      var index = match.startIndex;
      if (opts.allowTrailingComments) {
        // if there is a comment on the same line at after the comma, check the space after the comment.
        var execResult;
        while (execResult = /^[^\S\r\n]*\/\*([\s\S]*?)\*\//.exec(params.slice(index + 1))) {
          (0, _validateTypes.assertString)(execResult[0]);
          index += execResult[0].length;
        }
        if (execResult = /^([^\S\r\n]*\/\/[\s\S]*?)\r?\n/.exec(params.slice(index + 1))) {
          (0, _validateTypes.assertString)(execResult[1]);
          index += execResult[1].length;
        }
      }
      checkComma(params, index, atRule);
    });
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {import('postcss').AtRule} node
   */
  function checkComma(source, index, node) {
    opts.locationChecker({
      source: source,
      index: index,
      err: function err(message) {
        var commaIndex = index + (0, _atRuleParamIndex["default"])(node);
        if (opts.fix && opts.fix(node, commaIndex)) {
          return;
        }
        (0, _report["default"])({
          message: message,
          node: node,
          index: commaIndex,
          result: opts.result,
          ruleName: opts.checkedRuleName
        });
      }
    });
  }
}