"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.noEmptyFirstLineTest = exports.messages = exports["default"] = void 0;
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "no-empty-first-line";
exports.ruleName = ruleName;
var noEmptyFirstLineTest = /^\s*[\r\n]/;
exports.noEmptyFirstLineTest = noEmptyFirstLineTest;
var messages = (0, _ruleMessages["default"])(ruleName, {
  rejected: "Unexpected empty line"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/no-empty-first-line/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary
    });

    // @ts-expect-error -- TS2339: Property 'inline' does not exist on type 'Source'. Property 'lang' does not exist on type 'Source'.
    if (!validOptions || root.source.inline || root.source.lang === "object-literal") {
      return;
    }
    var rootString = context.fix ? root.toString() : root.source && root.source.input.css || "";
    if (!rootString.trim()) {
      return;
    }
    if (noEmptyFirstLineTest.test(rootString)) {
      if (context.fix) {
        if (root.first === null) {
          throw new Error("The root node must have the first node.");
        }
        if (root.first.raws.before === null) {
          throw new Error("The first node must have spaces before.");
        }
        root.first.raws.before = root.first.raws.before.trimStart();
        return;
      }
      (0, _report["default"])({
        message: messages.rejected,
        node: root,
        result: result,
        ruleName: ruleName
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;