"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxAtRule = _interopRequireDefault(require("../../utils/isStandardSyntaxAtRule.js"));
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _typeGuards = require("../../utils/typeGuards.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var ruleName = "no-extra-semicolons";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  rejected: "Unexpected extra semicolon"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/no-extra-semicolons/README.md",
  fixable: true
};

/**
 * @param {import('postcss').Node} node
 * @returns {number}
 */
exports.meta = meta;
function getOffsetByNode(node) {
  // @ts-expect-error -- TS2339: Property 'document' does not exist on type 'Document | Container<ChildNode>'
  if (node.parent && node.parent.document) {
    return 0;
  }
  var root = node.root();
  if (!root.source) {
    throw new Error("The root node must have a source");
  }
  if (!node.source) {
    throw new Error("The node must have a source");
  }
  if (!node.source.start) {
    throw new Error("The source must have a start position");
  }
  var string = root.source.input.css;
  var nodeColumn = node.source.start.column;
  var nodeLine = node.source.start.line;
  var line = 1;
  var column = 1;
  var index = 0;
  for (var i = 0; i < string.length; i++) {
    if (column === nodeColumn && nodeLine === line) {
      index = i;
      break;
    }
    if (string[i] === "\n") {
      column = 1;
      line += 1;
    } else {
      column += 1;
    }
  }
  return index;
}

/** @type {import('stylelint').Rule} */
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary
    });
    if (!validOptions) {
      return;
    }
    if (root.raws.after && root.raws.after.trim().length !== 0) {
      var rawAfterRoot = root.raws.after;

      /** @type {number[]} */
      var fixSemiIndices = [];
      (0, _styleSearch["default"])({
        source: rawAfterRoot,
        target: ";"
      }, function (match) {
        if (context.fix) {
          fixSemiIndices.push(match.startIndex);
          return;
        }
        if (!root.source) {
          throw new Error("The root node must have a source");
        }
        complain(root.source.input.css.length - rawAfterRoot.length + match.startIndex);
      });

      // fix
      if (fixSemiIndices.length) {
        root.raws.after = removeIndices(rawAfterRoot, fixSemiIndices);
      }
    }
    root.walk(function (node) {
      if ((0, _typeGuards.isAtRule)(node) && !(0, _isStandardSyntaxAtRule["default"])(node)) {
        return;
      }
      if (node.type === "rule" && !(0, _isStandardSyntaxRule["default"])(node)) {
        return;
      }
      if (node.raws.before && node.raws.before.trim().length !== 0) {
        var rawBeforeNode = node.raws.before;
        var allowedSemi = 0;
        var rawBeforeIndexStart = 0;

        /** @type {number[]} */
        var _fixSemiIndices = [];
        (0, _styleSearch["default"])({
          source: rawBeforeNode,
          target: ";"
        }, function (match, count) {
          if (count === allowedSemi) {
            return;
          }
          if (context.fix) {
            _fixSemiIndices.push(match.startIndex - rawBeforeIndexStart);
            return;
          }
          complain(getOffsetByNode(node) - rawBeforeNode.length + match.startIndex);
        });

        // fix
        if (_fixSemiIndices.length) {
          node.raws.before = removeIndices(rawBeforeNode, _fixSemiIndices);
        }
      }
      if (_typeof(node.raws.after) === "string" && node.raws.after.trim().length !== 0) {
        var rawAfterNode = node.raws.after;

        /**
        	 * If the last child is a Less mixin followed by more than one semicolon,
        	 * node.raws.after will be populated with that semicolon.
        	 * Since we ignore Less mixins, exit here
        	 */
        if ("last" in node && node.last && node.last.type === "atrule" && !(0, _isStandardSyntaxAtRule["default"])(node.last)) {
          return;
        }

        /** @type {number[]} */
        var _fixSemiIndices2 = [];
        (0, _styleSearch["default"])({
          source: rawAfterNode,
          target: ";"
        }, function (match) {
          if (context.fix) {
            _fixSemiIndices2.push(match.startIndex);
            return;
          }
          var index = getOffsetByNode(node) + node.toString().length - 1 - rawAfterNode.length + match.startIndex;
          complain(index);
        });

        // fix
        if (_fixSemiIndices2.length) {
          node.raws.after = removeIndices(rawAfterNode, _fixSemiIndices2);
        }
      }
      if (_typeof(node.raws.ownSemicolon) === "string") {
        var rawOwnSemicolon = node.raws.ownSemicolon;
        var _allowedSemi = 0;

        /** @type {number[]} */
        var _fixSemiIndices3 = [];
        (0, _styleSearch["default"])({
          source: rawOwnSemicolon,
          target: ";"
        }, function (match, count) {
          if (count === _allowedSemi) {
            return;
          }
          if (context.fix) {
            _fixSemiIndices3.push(match.startIndex);
            return;
          }
          var index = getOffsetByNode(node) + node.toString().length - rawOwnSemicolon.length + match.startIndex;
          complain(index);
        });

        // fix
        if (_fixSemiIndices3.length) {
          node.raws.ownSemicolon = removeIndices(rawOwnSemicolon, _fixSemiIndices3);
        }
      }
    });

    /**
    	 * @param {number} index
    	 */
    function complain(index) {
      (0, _report["default"])({
        message: messages.rejected,
        node: root,
        index: index,
        result: result,
        ruleName: ruleName
      });
    }

    /**
    	 * @param {string} str
    	 * @param {number[]} indices
    	 * @returns {string}
    	 */
    function removeIndices(str, indices) {
      var _iterator = _createForOfIteratorHelper(indices.reverse()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var index = _step.value;
          str = str.slice(0, index) + str.slice(index + 1);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return str;
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;