"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "no-missing-end-of-source-newline";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  rejected: "Unexpected missing end-of-source newline"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/no-missing-end-of-source-newline/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary
    });
    if (!validOptions) {
      return;
    }
    if (root.source === null) {
      throw new Error("The root node must have a source property");
    }

    // @ts-expect-error -- TS2339: Property 'inline' does not exist on type 'Source'.
    if (root.source.inline || root.source.lang === "object-literal") {
      return;
    }
    var rootString = context.fix ? root.toString() : root.source.input.css;
    if (!rootString.trim() || rootString.endsWith("\n")) {
      return;
    }

    // Fix
    if (context.fix) {
      root.raws.after = context.newline;
      return;
    }
    (0, _report["default"])({
      message: messages.rejected,
      node: root,
      index: rootString.length - 1,
      result: result,
      ruleName: ruleName
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;