"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _typeGuards = require("../../utils/typeGuards.js");
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "number-leading-zero";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: "Expected a leading zero",
  rejected: "Unexpected leading zero"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/number-leading-zero/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(function (atRule) {
      if (atRule.name.toLowerCase() === "import") {
        return;
      }
      check(atRule, atRule.params);
    });
    root.walkDecls(function (decl) {
      return check(decl, decl.value);
    });

    /**
    	 * @param {import('postcss').AtRule | import('postcss').Declaration} node
    	 * @param {string} value
    	 */
    function check(node, value) {
      /** @type {Array<{ startIndex: number, endIndex: number }>} */
      var neverFixPositions = [];
      /** @type {Array<{ index: number }>} */
      var alwaysFixPositions = [];

      // Get out quickly if there are no periods
      if (!value.includes(".")) {
        return;
      }
      (0, _postcssValueParser["default"])(value).walk(function (valueNode) {
        // Ignore `url` function
        if (valueNode.type === "function" && valueNode.value.toLowerCase() === "url") {
          return false;
        }

        // Ignore strings, comments, etc
        if (valueNode.type !== "word") {
          return;
        }

        // Check leading zero
        if (primary === "always") {
          var match = /(?:\D|^)(\.\d+)/.exec(valueNode.value);
          if (match === null || match[0] === null || match[1] === null) {
            return;
          }

          // The regexp above consists of 2 capturing groups (or capturing parentheses).
          // We need the index of the second group. This makes sanse when we have "-.5" as an input
          // for regex. And we need the index of ".5".
          var capturingGroupIndex = match[0].length - match[1].length;
          var index = valueNode.sourceIndex + match.index + capturingGroupIndex;
          if (context.fix) {
            alwaysFixPositions.unshift({
              index: index
            });
            return;
          }
          var baseIndex = (0, _typeGuards.isAtRule)(node) ? (0, _atRuleParamIndex["default"])(node) : (0, _declarationValueIndex["default"])(node);
          complain(messages.expected, node, baseIndex + index);
        }
        if (primary === "never") {
          var _match = /(?:\D|^)(0+)(\.\d+)/.exec(valueNode.value);
          if (_match === null || _match[0] === null || _match[1] === null || _match[2] === null) {
            return;
          }

          // The regexp above consists of 3 capturing groups (or capturing parentheses).
          // We need the index of the second group. This makes sanse when we have "-00.5"
          // as an input for regex. And we need the index of "00".
          var _capturingGroupIndex = _match[0].length - (_match[1].length + _match[2].length);
          var _index = valueNode.sourceIndex + _match.index + _capturingGroupIndex;
          if (context.fix) {
            neverFixPositions.unshift({
              startIndex: _index,
              // match[1].length is the length of our matched zero(s)
              endIndex: _index + _match[1].length
            });
            return;
          }
          var _baseIndex = (0, _typeGuards.isAtRule)(node) ? (0, _atRuleParamIndex["default"])(node) : (0, _declarationValueIndex["default"])(node);
          complain(messages.rejected, node, _baseIndex + _index);
        }
      });
      if (alwaysFixPositions.length) {
        var _iterator = _createForOfIteratorHelper(alwaysFixPositions),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var fixPosition = _step.value;
            var index = fixPosition.index;
            if ((0, _typeGuards.isAtRule)(node)) {
              node.params = addLeadingZero(node.params, index);
            } else {
              node.value = addLeadingZero(node.value, index);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
      if (neverFixPositions.length) {
        var _iterator2 = _createForOfIteratorHelper(neverFixPositions),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var _fixPosition = _step2.value;
            var startIndex = _fixPosition.startIndex;
            var endIndex = _fixPosition.endIndex;
            if ((0, _typeGuards.isAtRule)(node)) {
              node.params = removeLeadingZeros(node.params, startIndex, endIndex);
            } else {
              node.value = removeLeadingZeros(node.value, startIndex, endIndex);
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    }

    /**
    	 * @param {string} message
    	 * @param {import('postcss').Node} node
    	 * @param {number} index
    	 */
    function complain(message, node, index) {
      (0, _report["default"])({
        result: result,
        ruleName: ruleName,
        message: message,
        node: node,
        index: index
      });
    }
  };
};

/**
 * @param {string} input
 * @param {number} index
 * @returns {string}
 */
function addLeadingZero(input, index) {
  return "".concat(input.slice(0, index), "0").concat(input.slice(index));
}

/**
 * @param {string} input
 * @param {number} startIndex
 * @param {number} endIndex
 * @returns {string}
 */
function removeLeadingZeros(input, startIndex, endIndex) {
  return input.slice(0, startIndex) + input.slice(endIndex);
}
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;