"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _postcssValueParser = _interopRequireDefault(require("postcss-value-parser"));
var _atRuleParamIndex = _interopRequireDefault(require("../../utils/atRuleParamIndex.js"));
var _declarationValueIndex = _interopRequireDefault(require("../../utils/declarationValueIndex.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _typeGuards = require("../../utils/typeGuards.js");
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "number-no-trailing-zeros";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  rejected: "Unexpected trailing zero(s)"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/number-no-trailing-zeros/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary
    });
    if (!validOptions) {
      return;
    }
    root.walkAtRules(function (atRule) {
      if (atRule.name.toLowerCase() === "import") {
        return;
      }
      check(atRule, atRule.params);
    });
    root.walkDecls(function (decl) {
      return check(decl, decl.value);
    });

    /**
     * @param {import('postcss').AtRule | import('postcss').Declaration} node
     * @param {string} value
     */
    function check(node, value) {
      /** @type {Array<{ startIndex: number, endIndex: number }>} */
      var fixPositions = [];

      // Get out quickly if there are no periods
      if (!value.includes(".")) {
        return;
      }
      (0, _postcssValueParser["default"])(value).walk(function (valueNode) {
        // Ignore `url` function
        if (valueNode.type === "function" && valueNode.value.toLowerCase() === "url") {
          return false;
        }

        // Ignore strings, comments, etc
        if (valueNode.type !== "word") {
          return;
        }
        var match = /\.(\d{0,100}?)(0+)(?:\D|$)/.exec(valueNode.value);

        // match[1] is any numbers between the decimal and our trailing zero, could be empty
        // match[2] is our trailing zero(s)
        if (match === null || match[1] === null || match[2] === null) {
          return;
        }

        // our index is:
        //  the index of our valueNode +
        //  the index of our match +
        //  1 for our decimal +
        //  the length of our potential non-zero number match (match[1])
        var index = valueNode.sourceIndex + match.index + 1 + match[1].length;

        // our startIndex is identical to our index except when we have only
        // trailing zeros after our decimal. in that case we don't need the decimal
        // either so we move our index back by 1.
        var startIndex = match[1].length > 0 ? index : index - 1;

        // our end index is our original index + the length of our trailing zeros
        var endIndex = index + match[2].length;
        if (context.fix) {
          fixPositions.unshift({
            startIndex: startIndex,
            endIndex: endIndex
          });
          return;
        }
        var baseIndex = (0, _typeGuards.isAtRule)(node) ? (0, _atRuleParamIndex["default"])(node) : (0, _declarationValueIndex["default"])(node);
        (0, _report["default"])({
          message: messages.rejected,
          node: node,
          // this is the index of the _first_ trailing zero
          index: baseIndex + index,
          result: result,
          ruleName: ruleName
        });
      });
      if (fixPositions.length) {
        var _iterator = _createForOfIteratorHelper(fixPositions),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var fixPosition = _step.value;
            var startIndex = fixPosition.startIndex;
            var endIndex = fixPosition.endIndex;
            if ((0, _typeGuards.isAtRule)(node)) {
              node.params = removeTrailingZeros(node.params, startIndex, endIndex);
            } else {
              node.value = removeTrailingZeros(node.value, startIndex, endIndex);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
  };
};

/**
 * @param {string} input
 * @param {number} startIndex
 * @param {number} endIndex
 * @returns {string}
 */
function removeTrailingZeros(input, startIndex, endIndex) {
  return input.slice(0, startIndex) + input.slice(endIndex);
}
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;