"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _isCustomProperty = _interopRequireDefault(require("../../utils/isCustomProperty.js"));
var _isStandardSyntaxProperty = _interopRequireDefault(require("../../utils/isStandardSyntaxProperty.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _optionsMatches = _interopRequireDefault(require("../../utils/optionsMatches.js"));
var _validateTypes = require("../../utils/validateTypes.js");
var _typeGuards = require("../../utils/typeGuards.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "property-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/property-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    }, {
      actual: secondaryOptions,
      possible: {
        ignoreSelectors: [_validateTypes.isString, _validateTypes.isRegExp]
      },
      optional: true
    });
    if (!validOptions) {
      return;
    }
    root.walkDecls(function (decl) {
      var prop = decl.prop;
      if (!(0, _isStandardSyntaxProperty["default"])(prop)) {
        return;
      }
      if ((0, _isCustomProperty["default"])(prop)) {
        return;
      }
      var parent = decl.parent;
      if (!parent) {
        throw new Error("A parent node must be present");
      }
      if ((0, _typeGuards.isRule)(parent)) {
        var selector = parent.selector;
        if (selector && (0, _optionsMatches["default"])(secondaryOptions, "ignoreSelectors", selector)) {
          return;
        }
      }
      var expectedProp = primary === "lower" ? prop.toLowerCase() : prop.toUpperCase();
      if (prop === expectedProp) {
        return;
      }
      if (context.fix) {
        decl.prop = expectedProp;
        return;
      }
      (0, _report["default"])({
        message: messages.expected(prop, expectedProp),
        word: prop,
        node: decl,
        ruleName: ruleName,
        result: result
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;