"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _parseSelector = _interopRequireDefault(require("../../utils/parseSelector.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-attribute-brackets-space-inside";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedOpening: "Expected single space after \"[\"",
  rejectedOpening: "Unexpected whitespace after \"[\"",
  expectedClosing: "Expected single space before \"]\"",
  rejectedClosing: "Unexpected whitespace before \"]\""
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-attribute-brackets-space-inside/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    root.walkRules(function (ruleNode) {
      if (!(0, _isStandardSyntaxRule["default"])(ruleNode)) {
        return;
      }
      if (!ruleNode.selector.includes("[")) {
        return;
      }
      var selector = ruleNode.raws.selector ? ruleNode.raws.selector.raw : ruleNode.selector;
      var hasFixed;
      var fixedSelector = (0, _parseSelector["default"])(selector, result, ruleNode, function (selectorTree) {
        selectorTree.walkAttributes(function (attributeNode) {
          var attributeSelectorString = attributeNode.toString();
          (0, _styleSearch["default"])({
            source: attributeSelectorString,
            target: "["
          }, function (match) {
            var nextCharIsSpace = attributeSelectorString[match.startIndex + 1] === " ";
            var index = attributeNode.sourceIndex + match.startIndex + 1;
            if (nextCharIsSpace && primary === "never") {
              if (context.fix) {
                hasFixed = true;
                fixBefore(attributeNode);
                return;
              }
              complain(messages.rejectedOpening, index);
            }
            if (!nextCharIsSpace && primary === "always") {
              if (context.fix) {
                hasFixed = true;
                fixBefore(attributeNode);
                return;
              }
              complain(messages.expectedOpening, index);
            }
          });
          (0, _styleSearch["default"])({
            source: attributeSelectorString,
            target: "]"
          }, function (match) {
            var prevCharIsSpace = attributeSelectorString[match.startIndex - 1] === " ";
            var index = attributeNode.sourceIndex + match.startIndex - 1;
            if (prevCharIsSpace && primary === "never") {
              if (context.fix) {
                hasFixed = true;
                fixAfter(attributeNode);
                return;
              }
              complain(messages.rejectedClosing, index);
            }
            if (!prevCharIsSpace && primary === "always") {
              if (context.fix) {
                hasFixed = true;
                fixAfter(attributeNode);
                return;
              }
              complain(messages.expectedClosing, index);
            }
          });
        });
      });
      if (hasFixed && fixedSelector) {
        if (!ruleNode.raws.selector) {
          ruleNode.selector = fixedSelector;
        } else {
          ruleNode.raws.selector.raw = fixedSelector;
        }
      }

      /**
       * @param {string} message
       * @param {number} index
       */
      function complain(message, index) {
        (0, _report["default"])({
          message: message,
          index: index,
          result: result,
          ruleName: ruleName,
          node: ruleNode
        });
      }
    });
  };

  /**
   * @param {import('postcss-selector-parser').Attribute} attributeNode
   */
  function fixBefore(attributeNode) {
    var spacesAttribute = attributeNode.raws.spaces && attributeNode.raws.spaces.attribute;
    var rawAttrBefore = spacesAttribute && spacesAttribute.before;

    /** @type {{ attrBefore: string, setAttrBefore: (fixed: string) => void }} */
    var _ref = rawAttrBefore ? {
        attrBefore: rawAttrBefore,
        setAttrBefore: function setAttrBefore(fixed) {
          spacesAttribute.before = fixed;
        }
      } : {
        attrBefore: attributeNode.spaces.attribute && attributeNode.spaces.attribute.before || "",
        setAttrBefore: function setAttrBefore(fixed) {
          if (!attributeNode.spaces.attribute) {
            attributeNode.spaces.attribute = {};
          }
          attributeNode.spaces.attribute.before = fixed;
        }
      },
      attrBefore = _ref.attrBefore,
      setAttrBefore = _ref.setAttrBefore;
    if (primary === "always") {
      setAttrBefore(attrBefore.replace(/^\s*/, " "));
    } else if (primary === "never") {
      setAttrBefore(attrBefore.replace(/^\s*/, ""));
    }
  }

  /**
   * @param {import('postcss-selector-parser').Attribute} attributeNode
   */
  function fixAfter(attributeNode) {
    // eslint-disable-next-line no-nested-ternary
    var key = attributeNode.operator ? attributeNode.insensitive ? "insensitive" : "value" : "attribute";
    var rawSpaces = attributeNode.raws.spaces && attributeNode.raws.spaces[key];
    var rawAfter = rawSpaces && rawSpaces.after;
    var spaces = attributeNode.spaces[key];

    /** @type {{ after: string, setAfter: (fixed: string) => void }} */
    var _ref2 = rawAfter ? {
        after: rawAfter,
        setAfter: function setAfter(fixed) {
          rawSpaces.after = fixed;
        }
      } : {
        after: spaces && spaces.after || "",
        setAfter: function setAfter(fixed) {
          if (!attributeNode.spaces[key]) {
            attributeNode.spaces[key] = {};
          }

          // @ts-expect-error -- TS2532: Object is possibly 'undefined'.
          attributeNode.spaces[key].after = fixed;
        }
      },
      after = _ref2.after,
      setAfter = _ref2.setAfter;
    if (primary === "always") {
      setAfter(after.replace(/\s*$/, " "));
    } else if (primary === "never") {
      setAfter(after.replace(/\s*$/, ""));
    }
  }
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;