"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _selectorAttributeOperatorSpaceChecker = _interopRequireDefault(require("../selectorAttributeOperatorSpaceChecker.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-attribute-operator-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter(operator) {
    return "Expected single space after \"".concat(operator, "\"");
  },
  rejectedAfter: function rejectedAfter(operator) {
    return "Unexpected whitespace after \"".concat(operator, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-attribute-operator-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    (0, _selectorAttributeOperatorSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.after,
      checkedRuleName: ruleName,
      checkBeforeOperator: false,
      fix: context.fix ? function (attributeNode) {
        /** @type {{ operatorAfter: string, setOperatorAfter: (fixed: string) => void }} */
        var _ref = function () {
            var rawOperator = attributeNode.raws.operator;
            if (rawOperator) {
              return {
                operatorAfter: rawOperator.slice(attributeNode.operator ? attributeNode.operator.length : 0),
                setOperatorAfter: function setOperatorAfter(fixed) {
                  delete attributeNode.raws.operator;
                  if (!attributeNode.raws.spaces) {
                    attributeNode.raws.spaces = {};
                  }
                  if (!attributeNode.raws.spaces.operator) {
                    attributeNode.raws.spaces.operator = {};
                  }
                  attributeNode.raws.spaces.operator.after = fixed;
                }
              };
            }
            var rawSpacesOperator = attributeNode.raws.spaces && attributeNode.raws.spaces.operator;
            var rawOperatorAfter = rawSpacesOperator && rawSpacesOperator.after;
            if (rawOperatorAfter) {
              return {
                operatorAfter: rawOperatorAfter,
                setOperatorAfter: function setOperatorAfter(fixed) {
                  rawSpacesOperator.after = fixed;
                }
              };
            }
            return {
              operatorAfter: attributeNode.spaces.operator && attributeNode.spaces.operator.after || "",
              setOperatorAfter: function setOperatorAfter(fixed) {
                if (!attributeNode.spaces.operator) {
                  attributeNode.spaces.operator = {};
                }
                attributeNode.spaces.operator.after = fixed;
              }
            };
          }(),
          operatorAfter = _ref.operatorAfter,
          setOperatorAfter = _ref.setOperatorAfter;
        if (primary === "always") {
          setOperatorAfter(operatorAfter.replace(/^\s*/, " "));
          return true;
        }
        if (primary === "never") {
          setOperatorAfter(operatorAfter.replace(/^\s*/, ""));
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;