"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _selectorAttributeOperatorSpaceChecker = _interopRequireDefault(require("../selectorAttributeOperatorSpaceChecker.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-attribute-operator-space-before";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedBefore: function expectedBefore(operator) {
    return "Expected single space before \"".concat(operator, "\"");
  },
  rejectedBefore: function rejectedBefore(operator) {
    return "Unexpected whitespace before \"".concat(operator, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-attribute-operator-space-before/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    (0, _selectorAttributeOperatorSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.before,
      checkedRuleName: ruleName,
      checkBeforeOperator: true,
      fix: context.fix ? function (attributeNode) {
        var rawAttr = attributeNode.raws.spaces && attributeNode.raws.spaces.attribute;
        var rawAttrAfter = rawAttr && rawAttr.after;

        /** @type {{ attrAfter: string, setAttrAfter: (fixed: string) => void }} */
        var _ref = rawAttrAfter ? {
            attrAfter: rawAttrAfter,
            setAttrAfter: function setAttrAfter(fixed) {
              rawAttr.after = fixed;
            }
          } : {
            attrAfter: attributeNode.spaces.attribute && attributeNode.spaces.attribute.after || "",
            setAttrAfter: function setAttrAfter(fixed) {
              if (!attributeNode.spaces.attribute) {
                attributeNode.spaces.attribute = {};
              }
              attributeNode.spaces.attribute.after = fixed;
            }
          },
          attrAfter = _ref.attrAfter,
          setAttrAfter = _ref.setAttrAfter;
        if (primary === "always") {
          setAttrAfter(attrAfter.replace(/\s*$/, " "));
          return true;
        }
        if (primary === "never") {
          setAttrAfter(attrAfter.replace(/\s*$/, ""));
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;