"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _selectorCombinatorSpaceChecker = _interopRequireDefault(require("../selectorCombinatorSpaceChecker.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-combinator-space-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter(combinator) {
    return "Expected single space after \"".concat(combinator, "\"");
  },
  rejectedAfter: function rejectedAfter(combinator) {
    return "Unexpected whitespace after \"".concat(combinator, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-combinator-space-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("space", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions) {
      return;
    }
    (0, _selectorCombinatorSpaceChecker["default"])({
      root: root,
      result: result,
      locationChecker: checker.after,
      locationType: "after",
      checkedRuleName: ruleName,
      fix: context.fix ? function (combinator) {
        if (primary === "always") {
          combinator.spaces.after = " ";
          return true;
        }
        if (primary === "never") {
          combinator.spaces.after = "";
          return true;
        }
        return false;
      } : null
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;