"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _parseSelector = _interopRequireDefault(require("../../utils/parseSelector.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-descendant-combinator-no-non-space";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  rejected: function rejected(nonSpaceCharacter) {
    return "Unexpected \"".concat(nonSpaceCharacter, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-descendant-combinator-no-non-space/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary
    });
    if (!validOptions) {
      return;
    }
    root.walkRules(function (ruleNode) {
      if (!(0, _isStandardSyntaxRule["default"])(ruleNode)) {
        return;
      }
      var hasFixed = false;
      var selector = ruleNode.raws.selector ? ruleNode.raws.selector.raw : ruleNode.selector;

      // Return early for selectors containing comments
      // TODO: renable when parser and stylelint are compatible
      if (selector.includes("/*")) {
        return;
      }
      var fixedSelector = (0, _parseSelector["default"])(selector, result, ruleNode, function (fullSelector) {
        fullSelector.walkCombinators(function (combinatorNode) {
          if (combinatorNode.value !== " ") {
            return;
          }
          var value = combinatorNode.toString();
          if (value.includes("  ") || value.includes("\t") || value.includes("\n") || value.includes("\r")) {
            if (context.fix && /^\s+$/.test(value)) {
              hasFixed = true;
              if (!combinatorNode.raws) {
                combinatorNode.raws = {};
              }
              combinatorNode.raws.value = " ";
              combinatorNode.rawSpaceBefore = combinatorNode.rawSpaceBefore.replace(/^\s+/, "");
              combinatorNode.rawSpaceAfter = combinatorNode.rawSpaceAfter.replace(/\s+$/, "");
              return;
            }
            (0, _report["default"])({
              result: result,
              ruleName: ruleName,
              message: messages.rejected(value),
              node: ruleNode,
              index: combinatorNode.sourceIndex
            });
          }
        });
      });
      if (hasFixed && fixedSelector) {
        if (!ruleNode.raws.selector) {
          ruleNode.selector = fixedSelector;
        } else {
          ruleNode.raws.selector.raw = fixedSelector;
        }
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;