"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
var _whitespaceChecker = _interopRequireDefault(require("../../utils/whitespaceChecker.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var ruleName = "selector-list-comma-newline-after";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expectedAfter: function expectedAfter() {
    return "Expected newline after \",\"";
  },
  expectedAfterMultiLine: function expectedAfterMultiLine() {
    return "Expected newline after \",\" in a multi-line list";
  },
  rejectedAfterMultiLine: function rejectedAfterMultiLine() {
    return "Unexpected whitespace after \",\" in a multi-line list";
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-list-comma-newline-after/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  var checker = (0, _whitespaceChecker["default"])("newline", primary, messages);
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "always-multi-line", "never-multi-line"]
    });
    if (!validOptions) {
      return;
    }
    root.walkRules(function (ruleNode) {
      if (!(0, _isStandardSyntaxRule["default"])(ruleNode)) {
        return;
      }

      // Get raw selector so we can allow end-of-line comments, e.g.
      // a, /* comment */
      // b {}
      var selector = ruleNode.raws.selector ? ruleNode.raws.selector.raw : ruleNode.selector;

      /** @type {number[]} */
      var fixIndices = [];
      (0, _styleSearch["default"])({
        source: selector,
        target: ",",
        functionArguments: "skip"
      }, function (match) {
        var nextChars = selector.slice(match.endIndex);

        // If there's a // comment, that means there has to be a newline
        // ending the comment so we're fine
        if (/^\s+\/\//.test(nextChars)) {
          return;
        }

        // If there are spaces and then a comment begins, look for the newline
        var indextoCheckAfter = /^\s+\/\*/.test(nextChars) ? selector.indexOf("*/", match.endIndex) + 1 : match.startIndex;
        checker.afterOneOnly({
          source: selector,
          index: indextoCheckAfter,
          err: function err(m) {
            if (context.fix) {
              fixIndices.push(indextoCheckAfter + 1);
              return;
            }
            (0, _report["default"])({
              message: m,
              node: ruleNode,
              index: match.startIndex,
              result: result,
              ruleName: ruleName
            });
          }
        });
      });
      if (fixIndices.length) {
        var fixedSelector = selector;
        var _iterator = _createForOfIteratorHelper(fixIndices.sort(function (a, b) {
            return b - a;
          })),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var index = _step.value;
            var beforeSelector = fixedSelector.slice(0, index);
            var afterSelector = fixedSelector.slice(index);
            if (primary.startsWith("always")) {
              afterSelector = context.newline + afterSelector;
            } else if (primary.startsWith("never-multi-line")) {
              afterSelector = afterSelector.replace(/^\s*/, "");
            }
            fixedSelector = beforeSelector + afterSelector;
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        if (ruleNode.raws.selector) {
          ruleNode.raws.selector.raw = fixedSelector;
        } else {
          ruleNode.selector = fixedSelector;
        }
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;