"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _isStandardSyntaxSelector = _interopRequireDefault(require("../../utils/isStandardSyntaxSelector.js"));
var _selectors = require("../../reference/selectors.js");
var _parseSelector = _interopRequireDefault(require("../../utils/parseSelector.js"));
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-pseudo-class-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-pseudo-class-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }
    root.walkRules(function (ruleNode) {
      if (!(0, _isStandardSyntaxRule["default"])(ruleNode)) {
        return;
      }
      var selector = ruleNode.selector;
      if (!selector.includes(":")) {
        return;
      }
      var fixedSelector = (0, _parseSelector["default"])(ruleNode.raws.selector ? ruleNode.raws.selector.raw : ruleNode.selector, result, ruleNode, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudo = pseudoNode.value;
          if (!(0, _isStandardSyntaxSelector["default"])(pseudo)) {
            return;
          }
          if (pseudo.includes("::") || _selectors.levelOneAndTwoPseudoElements.has(pseudo.toLowerCase().slice(1))) {
            return;
          }
          var expectedPseudo = primary === "lower" ? pseudo.toLowerCase() : pseudo.toUpperCase();
          if (pseudo === expectedPseudo) {
            return;
          }
          if (context.fix) {
            pseudoNode.value = expectedPseudo;
            return;
          }
          (0, _report["default"])({
            message: messages.expected(pseudo, expectedPseudo),
            node: ruleNode,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
      if (context.fix && fixedSelector) {
        if (ruleNode.raws.selector) {
          ruleNode.raws.selector.raw = fixedSelector;
        } else {
          ruleNode.selector = fixedSelector;
        }
      }
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;