"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _isStandardSyntaxRule = _interopRequireDefault(require("../../utils/isStandardSyntaxRule.js"));
var _isStandardSyntaxSelector = _interopRequireDefault(require("../../utils/isStandardSyntaxSelector.js"));
var _selectors = require("../../reference/selectors.js");
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _transformSelector = _interopRequireDefault(require("../../utils/transformSelector.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "selector-pseudo-element-case";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: function expected(actual, _expected) {
    return "Expected \"".concat(actual, "\" to be \"").concat(_expected, "\"");
  }
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/selector-pseudo-element-case/README.md",
  fixable: true
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary, _secondaryOptions, context) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["lower", "upper"]
    });
    if (!validOptions) {
      return;
    }
    root.walkRules(function (ruleNode) {
      if (!(0, _isStandardSyntaxRule["default"])(ruleNode)) {
        return;
      }
      var selector = ruleNode.selector;
      if (!selector.includes(":")) {
        return;
      }
      (0, _transformSelector["default"])(result, ruleNode, function (selectorTree) {
        selectorTree.walkPseudos(function (pseudoNode) {
          var pseudoElement = pseudoNode.value;
          if (!(0, _isStandardSyntaxSelector["default"])(pseudoElement)) {
            return;
          }
          if (!pseudoElement.includes("::") && !_selectors.levelOneAndTwoPseudoElements.has(pseudoElement.toLowerCase().slice(1))) {
            return;
          }
          var expectedPseudoElement = primary === "lower" ? pseudoElement.toLowerCase() : pseudoElement.toUpperCase();
          if (pseudoElement === expectedPseudoElement) {
            return;
          }
          if (context.fix) {
            pseudoNode.value = expectedPseudoElement;
            return;
          }
          (0, _report["default"])({
            message: messages.expected(pseudoElement, expectedPseudoElement),
            node: ruleNode,
            index: pseudoNode.sourceIndex,
            ruleName: ruleName,
            result: result
          });
        });
      });
    });
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;