"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = selectorAttributeOperatorSpaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxRule = _interopRequireDefault(require("../utils/isStandardSyntaxRule.js"));
var _parseSelector = _interopRequireDefault(require("../utils/parseSelector.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   result: import('stylelint').PostcssResult,
 *   locationChecker: (opts: { source: string, index: number, err: (msg: string) => void }) => void,
 *   checkedRuleName: string,
 *   checkBeforeOperator: boolean,
 *   fix: ((attributeNode: import('postcss-selector-parser').Attribute) => boolean) | null,
 * }} options
 * @returns {void}
 */
function selectorAttributeOperatorSpaceChecker(options) {
  options.root.walkRules(function (rule) {
    if (!(0, _isStandardSyntaxRule["default"])(rule)) {
      return;
    }
    if (!rule.selector.includes("[") || !rule.selector.includes("=")) {
      return;
    }
    var hasFixed = false;
    var selector = rule.raws.selector ? rule.raws.selector.raw : rule.selector;
    var fixedSelector = (0, _parseSelector["default"])(selector, options.result, rule, function (selectorTree) {
      selectorTree.walkAttributes(function (attributeNode) {
        var operator = attributeNode.operator;
        if (!operator) {
          return;
        }
        var attributeNodeString = attributeNode.toString();
        (0, _styleSearch["default"])({
          source: attributeNodeString,
          target: operator
        }, function (match) {
          var index = options.checkBeforeOperator ? match.startIndex : match.endIndex - 1;
          checkOperator(attributeNodeString, index, rule, attributeNode, operator);
        });
      });
    });
    if (hasFixed && fixedSelector) {
      if (!rule.raws.selector) {
        rule.selector = fixedSelector;
      } else {
        rule.raws.selector.raw = fixedSelector;
      }
    }

    /**
     * @param {string} source
     * @param {number} index
     * @param {import('postcss').Node} node
     * @param {import('postcss-selector-parser').Attribute} attributeNode
     * @param {string} operator
     */
    function checkOperator(source, index, node, attributeNode, operator) {
      options.locationChecker({
        source: source,
        index: index,
        err: function err(msg) {
          if (options.fix && options.fix(attributeNode)) {
            hasFixed = true;
            return;
          }
          (0, _report["default"])({
            message: msg.replace(options.checkBeforeOperator ? operator.charAt(0) : operator.charAt(operator.length - 1), operator),
            node: node,
            index: attributeNode.sourceIndex + index,
            result: options.result,
            ruleName: options.checkedRuleName
          });
        }
      });
    }
  });
}