"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = selectorListCommaWhitespaceChecker;
var _styleSearch = _interopRequireDefault(require("style-search"));
var _isStandardSyntaxRule = _interopRequireDefault(require("../utils/isStandardSyntaxRule.js"));
var _report = _interopRequireDefault(require("../utils/report.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
/**
 * @param {{
 *   root: import('postcss').Root,
 *   result: import('stylelint').PostcssResult,
 *   locationChecker: (opts: { source: string, index: number, err: (msg: string) => void }) => void,
 *   checkedRuleName: string,
 *   fix: ((rule: import('postcss').Rule, index: number) => boolean) | null,
 * }} opts
 * @returns {void}
 */
function selectorListCommaWhitespaceChecker(opts) {
  opts.root.walkRules(function (rule) {
    if (!(0, _isStandardSyntaxRule["default"])(rule)) {
      return;
    }
    var selector = rule.raws.selector ? rule.raws.selector.raw : rule.selector;
    (0, _styleSearch["default"])({
      source: selector,
      target: ",",
      functionArguments: "skip"
    }, function (match) {
      checkDelimiter(selector, match.startIndex, rule);
    });
  });

  /**
   * @param {string} source
   * @param {number} index
   * @param {import('postcss').Rule} node
   */
  function checkDelimiter(source, index, node) {
    opts.locationChecker({
      source: source,
      index: index,
      err: function err(message) {
        if (opts.fix && opts.fix(node, index)) {
          return;
        }
        (0, _report["default"])({
          message: message,
          node: node,
          index: index,
          result: opts.result,
          ruleName: opts.checkedRuleName
        });
      }
    });
  }
}