"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleName = exports.meta = exports.messages = exports["default"] = void 0;
var _report = _interopRequireDefault(require("../../utils/report.js"));
var _ruleMessages = _interopRequireDefault(require("../../utils/ruleMessages.js"));
var _validateOptions = _interopRequireDefault(require("../../utils/validateOptions.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
var ruleName = "unicode-bom";
exports.ruleName = ruleName;
var messages = (0, _ruleMessages["default"])(ruleName, {
  expected: "Expected Unicode BOM",
  rejected: "Unexpected Unicode BOM"
});
exports.messages = messages;
var meta = {
  url: "https://github.com/firefoxic/stylelint-codeguide/blob/main/lib/rules/unicode-bom/README.md"
};

/** @type {import('stylelint').Rule} */
exports.meta = meta;
var rule = function rule(primary) {
  return function (root, result) {
    var validOptions = (0, _validateOptions["default"])(result, ruleName, {
      actual: primary,
      possible: ["always", "never"]
    });
    if (!validOptions || !root.source || root.source.inline || root.source.lang === "object-literal" || root.document !== undefined /* Ignore HTML documents */) {
      return;
    }
    var hasBOM = root.source.input.hasBOM;
    if (primary === "always" && !hasBOM) {
      (0, _report["default"])({
        result: result,
        ruleName: ruleName,
        message: messages.expected,
        node: root,
        line: 1
      });
    }
    if (primary === "never" && hasBOM) {
      (0, _report["default"])({
        result: result,
        ruleName: ruleName,
        message: messages.rejected,
        node: root,
        line: 1
      });
    }
  };
};
rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;
var _default = rule;
exports["default"] = _default;